/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.pojo.sort.dataflow.field.format;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.BasicFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.TimestampTypeInfo;

public class TimestampFormatInfo
implements BasicFormatInfo<Timestamp> {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_FORMAT = "format";
    private static final int DEFAULT_PRECISION_FOR_TIMESTAMP = 2;
    @JsonProperty(value="format")
    @Nonnull
    private final String format;
    @JsonProperty(value="precision")
    private int precision;

    @JsonCreator
    public TimestampFormatInfo(@JsonProperty(value="format") @Nonnull String format, @JsonProperty(value="precision") int precision) {
        this.format = format;
        this.precision = precision;
        if (!(format.equals("SECONDS") || format.equals("MILLIS") || format.equals("MICROS") || "SQL".equals(format) || "ISO_8601".equals(format))) {
            FastDateFormat.getInstance(format);
        }
    }

    public TimestampFormatInfo(@JsonProperty(value="format") @Nonnull String format) {
        this(format, 2);
    }

    public TimestampFormatInfo() {
        this("yyyy-MM-dd HH:mm:ss", 2);
    }

    public TimestampFormatInfo(@JsonProperty(value="precision") int precision) {
        this("yyyy-MM-dd HH:mm:ss", precision);
    }

    @Nonnull
    public String getFormat() {
        return this.format;
    }

    @Override
    public TimestampTypeInfo getTypeInfo() {
        return TimestampTypeInfo.INSTANCE;
    }

    @Override
    public String serialize(Timestamp timestamp) {
        switch (this.format) {
            case "MICROS": {
                long millis = timestamp.getTime();
                long micros = TimeUnit.MILLISECONDS.toMicros(millis);
                return Long.toString(micros);
            }
            case "MILLIS": {
                long millis = timestamp.getTime();
                return Long.toString(millis);
            }
            case "SECONDS": {
                long millis = timestamp.getTime();
                long seconds = TimeUnit.MILLISECONDS.toSeconds(millis);
                return Long.toString(seconds);
            }
        }
        return FastDateFormat.getInstance(this.format).format(timestamp.getTime());
    }

    @Override
    public Timestamp deserialize(String text) throws ParseException {
        switch (this.format) {
            case "MICROS": {
                long micros = Long.parseLong(text);
                long millis = TimeUnit.MICROSECONDS.toMillis(micros);
                return new Timestamp(millis);
            }
            case "MILLIS": {
                long millis = Long.parseLong(text);
                return new Timestamp(millis);
            }
            case "SECONDS": {
                long seconds = Long.parseLong(text);
                long millis = TimeUnit.SECONDS.toMillis(seconds);
                return new Timestamp(millis);
            }
        }
        Date date = FastDateFormat.getInstance(this.format).parse(text);
        return new Timestamp(date.getTime());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimestampFormatInfo that = (TimestampFormatInfo)o;
        return this.format.equals(that.format);
    }

    public int hashCode() {
        return Objects.hash(this.format);
    }

    public String toString() {
        return "TimestampFormatInfo{format='" + this.format + '\'' + '}';
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }
}

