/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ListUtil {
    public static <T, R> List<T> subtract(List<T> minuend, List<T> subtrahend, Function<T, R> keyExtractor) {
        if (CollectionUtils.isEmpty(subtrahend) || CollectionUtils.isEmpty(minuend)) {
            return minuend;
        }
        Map minuMap = ListUtil.toMap(minuend, keyExtractor);
        Map<R, T> substraMap = ListUtil.toMap(subtrahend, keyExtractor);
        substraMap.forEach((k, v) -> minuMap.remove(k));
        return new ArrayList<T>(minuMap.values());
    }

    public static <T, R> List<T> intersection(List<T> list1, List<T> list2, Function<T, R> keyExtractor) {
        if (CollectionUtils.isEmpty(list1) || CollectionUtils.isEmpty(list2)) {
            return new ArrayList();
        }
        Map map1 = ListUtil.toMap(list1, keyExtractor);
        Map<R, T> map2 = ListUtil.toMap(list2, keyExtractor);
        return map2.entrySet().stream().filter(entry -> map1.containsKey(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public static <T, R> List<R> intersectionKey(List<T> list1, List<T> list2, Function<T, R> keyExtractor) {
        if (CollectionUtils.isEmpty(list1) || CollectionUtils.isEmpty(list2)) {
            return new ArrayList();
        }
        Map<R, T> map1 = ListUtil.toMap(list1, keyExtractor);
        Map<R, T> map2 = ListUtil.toMap(list2, keyExtractor);
        return map2.keySet().stream().filter(map1::containsKey).collect(Collectors.toList());
    }

    public static <T> List<T> union(List<T> list1, List<T> list2) {
        ArrayList<T> result = new ArrayList<T>(list1);
        result.addAll(list2);
        return result;
    }

    public static <T, R> Map<R, T> toMap(List<T> list, Function<T, R> keyExtractor) {
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap();
        }
        return list.stream().collect(Collectors.toMap(keyExtractor, (? super T v) -> v));
    }
}

