/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.csv;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.DeserializationSchemaFactory;
import org.apache.flink.table.factories.SerializationSchemaFactory;
import org.apache.flink.table.factories.TableFormatFactoryBase;
import org.apache.flink.types.Row;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.BasicFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.RowFormatInfo;
import org.apache.inlong.sort.formats.base.DefaultTableFormatDeserializer;
import org.apache.inlong.sort.formats.base.DefaultTableFormatSerializer;
import org.apache.inlong.sort.formats.base.ProjectedDeserializationSchemaFactory;
import org.apache.inlong.sort.formats.base.ProjectedSerializationSchemaFactory;
import org.apache.inlong.sort.formats.base.TableFormatDeserializer;
import org.apache.inlong.sort.formats.base.TableFormatDeserializerFactory;
import org.apache.inlong.sort.formats.base.TableFormatSerializer;
import org.apache.inlong.sort.formats.base.TableFormatSerializerFactory;
import org.apache.inlong.sort.formats.base.TableFormatUtils;
import org.apache.inlong.sort.formats.csv.CsvDeserializationSchema;
import org.apache.inlong.sort.formats.csv.CsvSerializationSchema;
import org.apache.inlong.sort.formats.csv.CsvValidator;

public final class CsvFormatFactory
extends TableFormatFactoryBase<Row>
implements DeserializationSchemaFactory<Row>,
SerializationSchemaFactory<Row>,
ProjectedDeserializationSchemaFactory,
ProjectedSerializationSchemaFactory,
TableFormatSerializerFactory,
TableFormatDeserializerFactory {
    public CsvFormatFactory() {
        super("inlong-csv", 1, true);
    }

    public List<String> supportedFormatProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("format.schema");
        properties.add("format.charset");
        properties.add("format.delimiter");
        properties.add("format.escape-character");
        properties.add("format.quote-character");
        properties.add("format.null-literal");
        properties.add("format.ignore-errors");
        return properties;
    }

    public CsvDeserializationSchema createDeserializationSchema(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = CsvFormatFactory.getValidatedProperties(properties);
        RowFormatInfo rowFormatInfo = CsvFormatFactory.getValidatedRowFormatInfo(descriptorProperties);
        return CsvFormatFactory.buildDeserializationSchema(rowFormatInfo, descriptorProperties);
    }

    public CsvSerializationSchema createSerializationSchema(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = CsvFormatFactory.getValidatedProperties(properties);
        RowFormatInfo rowFormatInfo = CsvFormatFactory.getValidatedRowFormatInfo(descriptorProperties);
        return CsvFormatFactory.buildSerializationSchema(rowFormatInfo, descriptorProperties);
    }

    @Override
    public DeserializationSchema<Row> createProjectedDeserializationSchema(Map<String, String> properties, int[] fields) {
        DescriptorProperties descriptorProperties = CsvFormatFactory.getValidatedProperties(properties);
        RowFormatInfo rowFormatInfo = CsvFormatFactory.getValidatedRowFormatInfo(descriptorProperties);
        RowFormatInfo projectedRowFormatInfo = TableFormatUtils.projectRowFormatInfo(rowFormatInfo, fields);
        return CsvFormatFactory.buildDeserializationSchema(projectedRowFormatInfo, descriptorProperties);
    }

    @Override
    public SerializationSchema<Row> createProjectedSerializationSchema(Map<String, String> properties, int[] fields) {
        DescriptorProperties descriptorProperties = CsvFormatFactory.getValidatedProperties(properties);
        RowFormatInfo rowFormatInfo = CsvFormatFactory.getValidatedRowFormatInfo(descriptorProperties);
        RowFormatInfo projectedRowFormatInfo = TableFormatUtils.projectRowFormatInfo(rowFormatInfo, fields);
        return CsvFormatFactory.buildSerializationSchema(projectedRowFormatInfo, descriptorProperties);
    }

    @Override
    public TableFormatDeserializer createFormatDeserializer(Map<String, String> properties) {
        DeserializationSchema deserializationSchema = this.createDeserializationSchema((Map)properties);
        return new DefaultTableFormatDeserializer((DeserializationSchema<Row>)deserializationSchema);
    }

    @Override
    public TableFormatDeserializer createFormatDeserializer(TableFormatDeserializer.TableFormatContext context) {
        TableFormatDeserializer deserializer = this.createFormatDeserializer(context.getFormatProperties());
        deserializer.init(context);
        return deserializer;
    }

    @Override
    public TableFormatSerializer createFormatSerializer(Map<String, String> properties) {
        SerializationSchema serializationSchema = this.createSerializationSchema((Map)properties);
        return new DefaultTableFormatSerializer((SerializationSchema<Row>)serializationSchema);
    }

    @Override
    public TableFormatSerializer createFormatSerializer(TableFormatSerializer.TableFormatContext context) {
        TableFormatSerializer serializer = this.createFormatSerializer(context.getFormatProperties());
        serializer.init(context);
        return serializer;
    }

    private static DescriptorProperties getValidatedProperties(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = new DescriptorProperties(true);
        descriptorProperties.putProperties(properties);
        CsvValidator validator = new CsvValidator();
        validator.validate(descriptorProperties);
        return descriptorProperties;
    }

    private static RowFormatInfo getValidatedRowFormatInfo(DescriptorProperties descriptorProperties) {
        RowFormatInfo rowFormatInfo = TableFormatUtils.getRowFormatInfo(descriptorProperties);
        String[] fieldNames = rowFormatInfo.getFieldNames();
        FormatInfo[] fieldFormatInfos = rowFormatInfo.getFieldFormatInfos();
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            FormatInfo fieldFormatInfo = fieldFormatInfos[i];
            if (fieldFormatInfo instanceof BasicFormatInfo) continue;
            throw new ValidationException("The format for field " + fieldName + " is " + fieldFormatInfo.getClass().getSimpleName() + ". Only basic formats are supported in csv.");
        }
        return rowFormatInfo;
    }

    private static CsvDeserializationSchema buildDeserializationSchema(RowFormatInfo rowFormatInfo, DescriptorProperties descriptorProperties) {
        CsvDeserializationSchema.Builder builder = new CsvDeserializationSchema.Builder(rowFormatInfo);
        builder.configure(descriptorProperties);
        return builder.build();
    }

    private static CsvSerializationSchema buildSerializationSchema(RowFormatInfo rowFormatInfo, DescriptorProperties descriptorProperties) {
        CsvSerializationSchema.Builder builder = new CsvSerializationSchema.Builder(rowFormatInfo);
        builder.configure(descriptorProperties);
        return builder.build();
    }
}

