/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsg.row;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.csv.CsvRowDataDeserializationSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgHead;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgOptions;
import org.apache.inlong.sort.formats.inlongmsg.row.InLongMsgDeserializationSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InLongMsgDecodingFormat
implements DecodingFormat<DeserializationSchema<RowData>> {
    private static final Logger log = LoggerFactory.getLogger(InLongMsgDecodingFormat.class);
    private final String innerFormatMetaPrefix;
    private final DecodingFormat<DeserializationSchema<RowData>> innerDecodingFormat;
    private List<String> metadataKeys;
    private final boolean ignoreErrors;
    private final boolean ignoreTrailingUnmappable;
    private final boolean insertNullsForMissingColumns;
    private final boolean emptyStringAsNull;

    public InLongMsgDecodingFormat(DecodingFormat<DeserializationSchema<RowData>> innerDecodingFormat, String innerFormatMetaPrefix, ReadableConfig formatOptions) {
        this.innerDecodingFormat = innerDecodingFormat;
        this.innerFormatMetaPrefix = innerFormatMetaPrefix;
        this.metadataKeys = Collections.emptyList();
        this.ignoreErrors = (Boolean)formatOptions.get(InLongMsgOptions.IGNORE_PARSE_ERRORS);
        this.ignoreTrailingUnmappable = (Boolean)formatOptions.get(InLongMsgOptions.CSV_IGNORE_TRAILING_UNMAPPABLE);
        this.insertNullsForMissingColumns = (Boolean)formatOptions.get(InLongMsgOptions.CSV_INSERT_NULLS_FOR_MISSING_COLUMNS);
        this.emptyStringAsNull = (Boolean)formatOptions.get(InLongMsgOptions.CSV_EMPTY_STRING_AS_NULL);
    }

    public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType physicalDataType) {
        InLongMsgDeserializationSchema.MetadataConverter[] metadataConverters = (InLongMsgDeserializationSchema.MetadataConverter[])Arrays.stream(ReadableMetadata.values()).filter(metadata -> this.metadataKeys.contains(metadata.key)).map(metadata -> metadata.converter).toArray(InLongMsgDeserializationSchema.MetadataConverter[]::new);
        List readableMetadata = this.metadataKeys.stream().map(k -> Stream.of(ReadableMetadata.values()).filter(rm -> rm.key.equals(k)).findFirst().orElseThrow(IllegalStateException::new)).collect(Collectors.toList());
        List metadataFields = readableMetadata.stream().map(m4 -> DataTypes.FIELD((String)m4.key, (DataType)m4.dataType)).collect(Collectors.toList());
        DataType producedDataType = DataTypeUtils.appendRowFields((DataType)physicalDataType, metadataFields);
        TypeInformation producedTypeInfo = context.createTypeInformation(producedDataType);
        DeserializationSchema innerSchema = (DeserializationSchema)this.innerDecodingFormat.createRuntimeDecoder(context, physicalDataType);
        if (innerSchema instanceof CsvRowDataDeserializationSchema) {
            InLongMsgDecodingFormat.configCsvInnerFormat((DeserializationSchema<RowData>)innerSchema, this.ignoreTrailingUnmappable, this.insertNullsForMissingColumns, this.emptyStringAsNull);
        }
        return new InLongMsgDeserializationSchema((DeserializationSchema<RowData>)innerSchema, metadataConverters, (TypeInformation<RowData>)producedTypeInfo, this.ignoreErrors);
    }

    public Map<String, DataType> listReadableMetadata() {
        LinkedHashMap<String, DataType> metadataMap = new LinkedHashMap<String, DataType>();
        this.innerDecodingFormat.listReadableMetadata().forEach((key, value) -> metadataMap.putIfAbsent(this.innerFormatMetaPrefix + key, (DataType)value));
        Stream.of(ReadableMetadata.values()).forEachOrdered(m4 -> metadataMap.putIfAbsent(m4.key, m4.dataType));
        return metadataMap;
    }

    public void applyReadableMetadata(List<String> metadataKeys) {
        List innerFormatMetadataKeys = metadataKeys.stream().filter(k -> k.startsWith(this.innerFormatMetaPrefix)).collect(Collectors.toList());
        ArrayList<String> formatMetadataKeys = new ArrayList<String>(metadataKeys);
        formatMetadataKeys.removeAll(innerFormatMetadataKeys);
        this.metadataKeys = formatMetadataKeys;
        Map formatMetadata = this.innerDecodingFormat.listReadableMetadata();
        if (formatMetadata.size() > 0) {
            List requestedFormatMetadataKeys = innerFormatMetadataKeys.stream().map(k -> k.substring(this.innerFormatMetaPrefix.length())).collect(Collectors.toList());
            this.innerDecodingFormat.applyReadableMetadata(requestedFormatMetadataKeys);
        }
    }

    public ChangelogMode getChangelogMode() {
        return this.innerDecodingFormat.getChangelogMode();
    }

    @VisibleForTesting
    static void configCsvInnerFormat(DeserializationSchema<RowData> innerSchema, boolean ignoreTrailingUnmappable, boolean insertNullsForMissingColumns, boolean emptyStringAsNull) {
        try {
            Field readerField = CsvRowDataDeserializationSchema.class.getDeclaredField("objectReader");
            readerField.setAccessible(true);
            ObjectReader oldReader = (ObjectReader)readerField.get(innerSchema);
            Field schemaField = ObjectReader.class.getDeclaredField("_schema");
            schemaField.setAccessible(true);
            CsvSchema oldSchema = (CsvSchema)schemaField.get(oldReader);
            ObjectReader newReader = new CsvMapper().configure(CsvParser.Feature.IGNORE_TRAILING_UNMAPPABLE, ignoreTrailingUnmappable).configure(CsvParser.Feature.INSERT_NULLS_FOR_MISSING_COLUMNS, insertNullsForMissingColumns).configure(CsvParser.Feature.EMPTY_STRING_AS_NULL, emptyStringAsNull).readerFor(JsonNode.class).with(oldSchema);
            readerField.set(innerSchema, newReader);
        }
        catch (Throwable t2) {
            log.error("failed to make csv inner format to ignore trailing unmappable, ex is ", t2);
        }
    }

    static enum ReadableMetadata {
        DATA_TIME("data-time", (DataType)DataTypes.BIGINT().notNull(), new InLongMsgDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(InLongMsgHead head) {
                return head.getTime().getTime();
            }
        }),
        CREATE_TIME("create-time", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE().notNull(), new InLongMsgDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(InLongMsgHead head) {
                return TimestampData.fromTimestamp((Timestamp)head.getTime());
            }
        }),
        STREAM_ID("stream-id", (DataType)DataTypes.STRING().notNull(), new InLongMsgDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(InLongMsgHead head) {
                return StringData.fromString((String)head.getStreamId());
            }
        });

        final String key;
        final DataType dataType;
        final InLongMsgDeserializationSchema.MetadataConverter converter;

        private ReadableMetadata(String key, DataType dataType, InLongMsgDeserializationSchema.MetadataConverter converter) {
            this.key = key;
            this.dataType = dataType;
            this.converter = converter;
        }
    }
}

