/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsg.row;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.TableFormatFactoryBase;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.RowFormatInfo;
import org.apache.inlong.sort.formats.base.TableFormatForRowUtils;
import org.apache.inlong.sort.formats.base.TableFormatUtils;
import org.apache.inlong.sort.formats.inlongmsg.FailureHandler;
import org.apache.inlong.sort.formats.inlongmsg.IgnoreFailureHandler;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgBody;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgHead;
import org.apache.inlong.sort.formats.inlongmsg.NoOpFailureHandler;
import org.apache.inlong.sort.formats.util.StringUtils;

public class InLongMsgUtils {
    public static final char INLONGMSG_ATTR_ENTRY_DELIMITER = '&';
    public static final char INLONGMSG_ATTR_KV_DELIMITER = '=';
    public static final String INLONGMSG_ATTR_STREAM_ID = "streamId";
    @Deprecated
    public static final String INLONGMSG_ATTR_INTERFACE_NAME = "iname";
    @Deprecated
    public static final String INLONGMSG_ATTR_TID = "tid";
    public static final String INLONGMSG_ATTR_TIME_T = "t";
    public static final String INLONGMSG_ATTR_TIME_DT = "dt";
    public static final String INLONGMSG_ATTR_ADD_COLUMN_PREFIX = "__addcol";
    public static final String FORMAT_TIME_FIELD_NAME = "format.time-field-name";
    public static final String FORMAT_ATTRIBUTES_FIELD_NAME = "format.attributes-field-name";
    public static final String FORMAT_RETAIN_PREDEFINED_FIELD = "format.retain-predefined-field";
    public static final String FORMAT_APPEND_ESCAPE_FIELD = "format.append-escape";
    public static final String DEFAULT_TIME_FIELD_NAME = "inlongmsg_time";
    public static final String DEFAULT_ATTRIBUTES_FIELD_NAME = "inlongmsg_attributes";
    public static final boolean DEFAULT_PREDEFINED_FIELD = true;
    public static final boolean DEFAULT_APPEND_ESCAPE = false;
    public static final TypeInformation<Row> MIXED_ROW_TYPE = Types.ROW_NAMED((String[])new String[]{"attributes", "data", "streamId", "time", "predefinedFields", "fields", "entries"}, (TypeInformation[])new TypeInformation[]{Types.MAP((TypeInformation)Types.STRING, (TypeInformation)Types.STRING), Types.PRIMITIVE_ARRAY((TypeInformation)Types.BYTE), Types.STRING, Types.SQL_TIMESTAMP, Types.LIST((TypeInformation)Types.STRING), Types.LIST((TypeInformation)Types.STRING), Types.MAP((TypeInformation)Types.STRING, (TypeInformation)Types.STRING)});

    public static RowFormatInfo getDataFormatInfo(DescriptorProperties descriptorProperties) {
        if (descriptorProperties.containsKey("format.schema")) {
            return TableFormatUtils.deserializeRowFormatInfo(descriptorProperties);
        }
        TableSchema tableSchema = TableFormatFactoryBase.deriveSchema((Map)descriptorProperties.asMap());
        String[] fieldNames = tableSchema.getFieldNames();
        DataType[] fieldTypes = tableSchema.getFieldDataTypes();
        String[] dataFieldNames = new String[fieldNames.length - 2];
        FormatInfo[] dataFieldFormatInfos = new FormatInfo[fieldNames.length - 2];
        for (int i = 0; i < dataFieldNames.length; ++i) {
            dataFieldNames[i] = fieldNames[i + 2];
            dataFieldFormatInfos[i] = TableFormatForRowUtils.deriveFormatInfo(fieldTypes[i + 2].getLogicalType());
        }
        return new RowFormatInfo(dataFieldNames, dataFieldFormatInfos);
    }

    public static RowFormatInfo getDataRowFormatInfo(DescriptorProperties descriptorProperties) {
        RowFormatInfo rowFormatInfo = TableFormatUtils.deserializeRowFormatInfo(descriptorProperties);
        HashSet fieldNames = new HashSet();
        Collections.addAll(fieldNames, rowFormatInfo.getFieldNames());
        String timeFieldName = descriptorProperties.getOptionalString(FORMAT_TIME_FIELD_NAME).orElse(DEFAULT_TIME_FIELD_NAME);
        if (timeFieldName != null && fieldNames.contains(timeFieldName)) {
            throw new ValidationException("The name of the time field " + timeFieldName + " conflicts with one of the data fields.");
        }
        String attributesFieldName = descriptorProperties.getOptionalString(FORMAT_ATTRIBUTES_FIELD_NAME).orElse(DEFAULT_ATTRIBUTES_FIELD_NAME);
        if (attributesFieldName != null && fieldNames.contains(attributesFieldName)) {
            throw new ValidationException("The name of the attributes field " + attributesFieldName + " conflicts with one of the data fields.");
        }
        return rowFormatInfo;
    }

    public static InLongMsgHead parseHead(String attr) {
        Timestamp time;
        String streamId;
        Map<String, String> attributes = InLongMsgUtils.parseAttr(attr);
        if (attributes.containsKey(INLONGMSG_ATTR_STREAM_ID)) {
            streamId = attributes.get(INLONGMSG_ATTR_STREAM_ID);
        } else if (attributes.containsKey(INLONGMSG_ATTR_TID)) {
            streamId = attributes.get(INLONGMSG_ATTR_TID);
        } else {
            throw new IllegalArgumentException("Could not find streamId in attributes!");
        }
        if (attributes.containsKey(INLONGMSG_ATTR_TIME_T)) {
            String date = attributes.get(INLONGMSG_ATTR_TIME_T).trim();
            time = InLongMsgUtils.parseDateTime(date);
        } else if (attributes.containsKey(INLONGMSG_ATTR_TIME_DT)) {
            String epoch = attributes.get(INLONGMSG_ATTR_TIME_DT).trim();
            time = InLongMsgUtils.parseEpochTime(epoch);
        } else {
            throw new IllegalArgumentException("Could not find t or dt in attributes!");
        }
        List<String> predefinedFields = InLongMsgUtils.getPredefinedFields(attributes);
        return new InLongMsgHead(attributes, streamId, time, predefinedFields);
    }

    public static Map<String, String> parseAttr(String attr) {
        return StringUtils.splitKv(attr, Character.valueOf('&'), Character.valueOf('='), null, null);
    }

    public static Timestamp parseEpochTime(String value) {
        long millis = Long.parseLong(value);
        return new Timestamp(millis);
    }

    public static Timestamp parseDateTime(String value) {
        try {
            if (value.length() < 8) {
                return null;
            }
            if (value.length() <= 9) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                Date date = simpleDateFormat.parse(value.substring(0, 8));
                return new Timestamp(date.getTime());
            }
            if (value.length() <= 11) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHH");
                Date date = simpleDateFormat.parse(value.substring(0, 10));
                return new Timestamp(date.getTime());
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmm");
            Date date = simpleDateFormat.parse(value.substring(0, 12));
            return new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unexpected time format : " + value + ".");
        }
    }

    public static List<String> getPredefinedFields(Map<String, String> head) {
        HashMap<Integer, String> predefinedFields = new HashMap<Integer, String>();
        for (String key : head.keySet()) {
            if (!key.startsWith(INLONGMSG_ATTR_ADD_COLUMN_PREFIX)) continue;
            int index = Integer.parseInt(key.substring(INLONGMSG_ATTR_ADD_COLUMN_PREFIX.length(), key.indexOf(95, INLONGMSG_ATTR_ADD_COLUMN_PREFIX.length())));
            predefinedFields.put(index, head.get(key));
        }
        ArrayList<String> result = new ArrayList<String>(predefinedFields.size());
        for (int i = 0; i < predefinedFields.size(); ++i) {
            String predefinedField = (String)predefinedFields.get(i + 1);
            result.add(predefinedField);
        }
        return result;
    }

    public static Row buildMixedRow(InLongMsgHead head, InLongMsgBody body, String streamId) {
        Row row = new Row(7);
        row.setField(0, head.getAttributes());
        row.setField(1, (Object)body.getData());
        row.setField(2, (Object)streamId);
        row.setField(3, (Object)head.getTime());
        row.setField(4, head.getPredefinedFields());
        row.setField(5, body.getFields());
        row.setField(6, body.getEntries());
        return row;
    }

    public static Map<String, String> getAttributesFromMixedRow(Row row) {
        return (Map)row.getField(0);
    }

    public static byte[] getDataFromMixedRow(Row row) {
        return (byte[])row.getField(1);
    }

    public static String getStreamIdFromMixedRow(Row row) {
        return (String)row.getField(2);
    }

    public static Timestamp getTimeFromMixedRow(Row row) {
        return (Timestamp)row.getField(3);
    }

    public static List<String> getPredefinedFieldsFromMixedRow(Row row) {
        return (List)row.getField(4);
    }

    public static List<String> getFieldsFromMixedRow(Row row) {
        return (List)row.getField(5);
    }

    public static Map<String, String> getEntriesFromMixedRow(Row row) {
        return (Map)row.getField(6);
    }

    public static void validateFieldNames(String timeFieldName, String attributesFieldName, RowFormatInfo rowFormatInfo) {
        String[] dataFieldNames;
        if (Objects.equals(timeFieldName, attributesFieldName)) {
            throw new ValidationException("The names of the time and attributes fields are same.");
        }
        for (String dataFieldName : dataFieldNames = rowFormatInfo.getFieldNames()) {
            if (dataFieldName.equals(timeFieldName)) {
                throw new ValidationException("The time field " + timeFieldName + " is already defined in the schema.");
            }
            if (!dataFieldName.equals(attributesFieldName)) continue;
            throw new ValidationException("The attributes field " + attributesFieldName + " is already defined in the schema.");
        }
    }

    public static void validateInLongMsgSchema(DescriptorProperties descriptorProperties) {
        TableFormatUtils.validateSchema(descriptorProperties);
        descriptorProperties.validateString(FORMAT_TIME_FIELD_NAME, true, 1);
        descriptorProperties.validateString(FORMAT_ATTRIBUTES_FIELD_NAME, true, 1);
    }

    public static TypeInformation<Row> buildRowType(String timeFieldName, String attributesFieldName, RowFormatInfo rowFormatInfo) {
        String[] dataFieldNames = rowFormatInfo.getFieldNames();
        String[] fieldNames = new String[dataFieldNames.length + 2];
        fieldNames[0] = timeFieldName;
        fieldNames[1] = attributesFieldName;
        System.arraycopy(dataFieldNames, 0, fieldNames, 2, dataFieldNames.length);
        FormatInfo[] dataFieldFormatInfos = rowFormatInfo.getFieldFormatInfos();
        TypeInformation[] fieldTypes = new TypeInformation[dataFieldFormatInfos.length + 2];
        fieldTypes[0] = Types.SQL_TIMESTAMP;
        fieldTypes[1] = Types.MAP((TypeInformation)Types.STRING, (TypeInformation)Types.STRING);
        for (int i = 0; i < dataFieldFormatInfos.length; ++i) {
            fieldTypes[i + 2] = TableFormatForRowUtils.getType(dataFieldFormatInfos[i].getTypeInfo());
        }
        return Types.ROW_NAMED((String[])fieldNames, (TypeInformation[])fieldTypes);
    }

    public static FailureHandler getDefaultExceptionHandler(boolean ignoreErrors) {
        if (ignoreErrors) {
            return new IgnoreFailureHandler();
        }
        return new NoOpFailureHandler();
    }

    public static TypeInformation<Row> decorateRowTypeWithNeededHeadFields(@Nullable String timeFieldName, @Nullable String attributesFieldName, RowFormatInfo dataRowFormatInfo) {
        RowTypeInfo rowTypeInfo = (RowTypeInfo)TableFormatForRowUtils.getType(dataRowFormatInfo.getTypeInfo());
        return InLongMsgUtils.decorateRowTypeWithNeededHeadFields(timeFieldName, attributesFieldName, rowTypeInfo);
    }

    public static TypeInformation<Row> decorateRowTypeWithNeededHeadFields(@Nullable String timeFieldName, @Nullable String attributesFieldName, RowTypeInfo dataRowType) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<TypeInformation> fieldTypes = new ArrayList<TypeInformation>();
        if (timeFieldName != null) {
            fieldNames.add(timeFieldName);
            fieldTypes.add(Types.SQL_TIMESTAMP);
        }
        if (attributesFieldName != null) {
            fieldNames.add(attributesFieldName);
            fieldTypes.add(Types.MAP((TypeInformation)Types.STRING, (TypeInformation)Types.STRING));
        }
        String[] dataFieldNames = dataRowType.getFieldNames();
        TypeInformation[] dataFieldTypes = dataRowType.getFieldTypes();
        for (int i = 0; i < dataFieldNames.length; ++i) {
            fieldNames.add(dataFieldNames[i]);
            fieldTypes.add(dataFieldTypes[i]);
        }
        return Types.ROW_NAMED((String[])fieldNames.toArray(new String[0]), (TypeInformation[])fieldTypes.toArray(new TypeInformation[0]));
    }

    public static Row decorateRowWithNeededHeadFields(@Nullable String timeFieldName, @Nullable String attributesFieldName, Timestamp time, Map<String, String> attributes, Row dataRow) {
        int i;
        ArrayList<Object> headFields = new ArrayList<Object>(2);
        if (timeFieldName != null) {
            headFields.add(time);
        }
        if (attributesFieldName != null) {
            headFields.add(attributes);
        }
        Row row = new Row(headFields.size() + dataRow.getArity());
        for (i = 0; i < headFields.size(); ++i) {
            row.setField(i, headFields.get(i));
        }
        for (i = 0; i < dataRow.getArity(); ++i) {
            row.setField(i + headFields.size(), dataRow.getField(i));
        }
        return row;
    }
}

