/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsgkv;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.types.Row;
import org.apache.inlong.sort.formats.base.TableFormatConstants;
import org.apache.inlong.sort.formats.inlongmsg.FailureHandler;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgBody;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgHead;
import org.apache.inlong.sort.formats.inlongmsg.row.AbstractInLongMsgMixedFormatDeserializer;
import org.apache.inlong.sort.formats.inlongmsg.row.InLongMsgTextMixedFormatDeserializerBuilder;
import org.apache.inlong.sort.formats.inlongmsg.row.InLongMsgUtils;
import org.apache.inlong.sort.formats.inlongmsgkv.InLongMsgKvUtils;

public final class InLongMsgKvMixedFormatDeserializer
extends AbstractInLongMsgMixedFormatDeserializer {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final String charset;
    @Nonnull
    private final Character entryDelimiter;
    @Nonnull
    private final Character kvDelimiter;
    @Nullable
    private final Character lineDelimiter;
    @Nullable
    private final Character escapeChar;
    @Nullable
    private final Character quoteChar;

    public InLongMsgKvMixedFormatDeserializer(@Nonnull String charset, @Nonnull Character entryDelimiter, @Nonnull Character kvDelimiter, @Nullable Character lineDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nonnull Boolean ignoreErrors) {
        this(charset, entryDelimiter, kvDelimiter, lineDelimiter, escapeChar, quoteChar, InLongMsgUtils.getDefaultExceptionHandler(ignoreErrors));
    }

    public InLongMsgKvMixedFormatDeserializer(@Nonnull String charset, @Nonnull Character entryDelimiter, @Nonnull Character kvDelimiter, @Nullable Character lineDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nonnull FailureHandler failureHandler) {
        super(failureHandler);
        this.entryDelimiter = entryDelimiter;
        this.kvDelimiter = kvDelimiter;
        this.lineDelimiter = lineDelimiter;
        this.charset = charset;
        this.escapeChar = escapeChar;
        this.quoteChar = quoteChar;
    }

    public TypeInformation<Row> getProducedType() {
        return InLongMsgUtils.MIXED_ROW_TYPE;
    }

    @Override
    protected InLongMsgHead parseHead(String attr) {
        return InLongMsgKvUtils.parseHead(attr);
    }

    @Override
    protected List<InLongMsgBody> parseBodyList(byte[] bytes) throws Exception {
        return InLongMsgKvUtils.parseBodyList(bytes, this.charset, this.entryDelimiter.charValue(), this.kvDelimiter.charValue(), this.lineDelimiter, this.escapeChar, this.quoteChar);
    }

    @Override
    protected List<Row> convertRows(InLongMsgHead head, InLongMsgBody body) {
        Row row = InLongMsgUtils.buildMixedRow(head, body, head.getStreamId());
        return Collections.singletonList(row);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        InLongMsgKvMixedFormatDeserializer that = (InLongMsgKvMixedFormatDeserializer)((Object)object);
        return this.charset.equals(that.charset) && this.entryDelimiter.equals(that.entryDelimiter) && this.kvDelimiter.equals(that.kvDelimiter) && Objects.equals(this.lineDelimiter, that.lineDelimiter) && Objects.equals(this.escapeChar, that.escapeChar) && Objects.equals(this.quoteChar, that.quoteChar);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.charset, this.entryDelimiter, this.kvDelimiter, this.lineDelimiter, this.escapeChar, this.quoteChar);
    }

    public static class Builder
    extends InLongMsgTextMixedFormatDeserializerBuilder<Builder> {
        private Character entryDelimiter = Character.valueOf('&');
        private Character kvDelimiter = Character.valueOf('=');
        private Character lineDelimiter = TableFormatConstants.DEFAULT_LINE_DELIMITER;

        public Builder() {
            this.charset = "ISO_8859_1";
        }

        public Builder setEntryDelimiter(Character entryDelimiter) {
            this.entryDelimiter = entryDelimiter;
            return this;
        }

        public Builder setKvDelimiter(Character kvDelimiter) {
            this.kvDelimiter = kvDelimiter;
            return this;
        }

        public Builder setLineDelimiter(Character lineDelimiter) {
            this.lineDelimiter = lineDelimiter;
            return this;
        }

        @Override
        public Builder configure(DescriptorProperties descriptorProperties) {
            super.configure(descriptorProperties);
            descriptorProperties.getOptionalCharacter("format.entry-delimiter").ifPresent(this::setEntryDelimiter);
            descriptorProperties.getOptionalCharacter("format.kv-delimiter").ifPresent(this::setKvDelimiter);
            descriptorProperties.getOptionalCharacter("format.line-delimiter").ifPresent(this::setLineDelimiter);
            return this;
        }

        public InLongMsgKvMixedFormatDeserializer build() {
            return new InLongMsgKvMixedFormatDeserializer(this.charset, this.entryDelimiter, this.kvDelimiter, this.lineDelimiter, this.escapeChar, this.quoteChar, this.ignoreErrors);
        }
    }
}

