/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.extract;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.Metadata;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.transformation.WatermarkField;

@JsonTypeName(value="sqlserverExtract")
public class SqlServerExtractNode
extends ExtractNode
implements InlongMetric,
Metadata,
Serializable {
    private static final long serialVersionUID = 5096171152872086083L;
    @JsonProperty(value="hostname")
    @Nonnull
    private String hostname;
    @JsonProperty(value="port")
    @Nonnull
    private Integer port;
    @JsonProperty(value="username")
    @Nonnull
    private String username;
    @JsonProperty(value="password")
    @Nonnull
    private String password;
    @JsonProperty(value="database")
    @Nonnull
    private String database;
    @JsonProperty(value="schemaName", defaultValue="dbo")
    @Nonnull
    private String schemaName;
    @JsonProperty(value="tableName")
    @Nonnull
    private String tableName;
    @JsonProperty(value="serverTimeZone")
    private String serverTimeZone;
    @JsonProperty(value="primaryKey")
    private String primaryKey;

    @JsonCreator
    public SqlServerExtractNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="watermarkField") WatermarkField waterMarkField, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="primaryKey") String primaryKey, @JsonProperty(value="hostname") @Nonnull String hostname, @JsonProperty(value="port", defaultValue="1433") Integer port, @JsonProperty(value="username") @Nonnull String username, @JsonProperty(value="password") @Nonnull String password, @JsonProperty(value="database") @Nonnull String database, @JsonProperty(value="schemaName", defaultValue="dbo") String schemaName, @JsonProperty(value="tableName") @Nonnull String tableName, @JsonProperty(value="serverTimeZone") String serverTimeZone) {
        super(id, name, fields, waterMarkField, properties);
        this.tableName = Preconditions.checkNotNull(tableName, "tableName is null");
        this.hostname = Preconditions.checkNotNull(hostname, "hostname is null");
        this.username = Preconditions.checkNotNull(username, "username is null");
        this.password = Preconditions.checkNotNull(password, "password is null");
        this.database = Preconditions.checkNotNull(database, "database is null");
        this.schemaName = Preconditions.checkNotNull(schemaName, "schema is null");
        this.primaryKey = primaryKey;
        this.port = port;
        this.serverTimeZone = serverTimeZone;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> map = super.tableOptions();
        map.put("connector", "sqlserver-cdc-inlong");
        map.put("hostname", this.hostname);
        map.put("port", this.port.toString());
        map.put("username", this.username);
        map.put("password", this.password);
        map.put("database-name", this.database);
        map.put("schema-name", this.schemaName);
        map.put("table-name", this.tableName);
        if (null != this.serverTimeZone) {
            map.put("server-time-zone", this.serverTimeZone);
        }
        return map;
    }

    @Override
    public String genTableName() {
        return String.format("table_%s", super.getId());
    }

    @Override
    public boolean isVirtual(MetaField metaField) {
        return true;
    }

    @Override
    public Set<MetaField> supportedMetaFields() {
        return EnumSet.of(MetaField.PROCESS_TIME, MetaField.TABLE_NAME, MetaField.DATABASE_NAME, MetaField.SCHEMA_NAME, MetaField.OP_TS);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlServerExtractNode)) {
            return false;
        }
        SqlServerExtractNode other = (SqlServerExtractNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$serverTimeZone = this.getServerTimeZone();
        String other$serverTimeZone = other.getServerTimeZone();
        if (this$serverTimeZone == null ? other$serverTimeZone != null : !this$serverTimeZone.equals(other$serverTimeZone)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SqlServerExtractNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $serverTimeZone = this.getServerTimeZone();
        result = result * 59 + ($serverTimeZone == null ? 43 : $serverTimeZone.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }

    @Nonnull
    public String getHostname() {
        return this.hostname;
    }

    @Nonnull
    public Integer getPort() {
        return this.port;
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    @Nonnull
    public String getPassword() {
        return this.password;
    }

    @Nonnull
    public String getDatabase() {
        return this.database;
    }

    @Nonnull
    public String getSchemaName() {
        return this.schemaName;
    }

    @Nonnull
    public String getTableName() {
        return this.tableName;
    }

    public String getServerTimeZone() {
        return this.serverTimeZone;
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setHostname(@Nonnull String hostname) {
        if (hostname == null) {
            throw new NullPointerException("hostname is marked non-null but is null");
        }
        this.hostname = hostname;
    }

    public void setPort(@Nonnull Integer port) {
        if (port == null) {
            throw new NullPointerException("port is marked non-null but is null");
        }
        this.port = port;
    }

    public void setUsername(@Nonnull String username) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        this.username = username;
    }

    public void setPassword(@Nonnull String password) {
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.password = password;
    }

    public void setDatabase(@Nonnull String database) {
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        this.database = database;
    }

    public void setSchemaName(@Nonnull String schemaName) {
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        this.schemaName = schemaName;
    }

    public void setTableName(@Nonnull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        this.tableName = tableName;
    }

    public void setServerTimeZone(String serverTimeZone) {
        this.serverTimeZone = serverTimeZone;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Override
    public String toString() {
        return "SqlServerExtractNode(hostname=" + this.getHostname() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName() + ", serverTimeZone=" + this.getServerTimeZone() + ", primaryKey=" + this.getPrimaryKey() + ")";
    }
}

