/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter2.predicate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.filter2.predicate.PrimitiveToBoxedClass;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.schema.PrimitiveType;

public class ValidTypeMap {
    private static final Map<Class<?>, Set<PrimitiveType.PrimitiveTypeName>> classToParquetType = new HashMap();
    private static final Map<PrimitiveType.PrimitiveTypeName, Set<Class<?>>> parquetTypeToClass = new HashMap();

    private ValidTypeMap() {
    }

    private static void add(Class<?> c, PrimitiveType.PrimitiveTypeName p) {
        Set<PrimitiveType.PrimitiveTypeName> descriptors = classToParquetType.get(c);
        if (descriptors == null) {
            descriptors = new HashSet<PrimitiveType.PrimitiveTypeName>();
            classToParquetType.put(c, descriptors);
        }
        descriptors.add(p);
        Set<Class<?>> classes = parquetTypeToClass.get((Object)p);
        if (classes == null) {
            classes = new HashSet();
            parquetTypeToClass.put(p, classes);
        }
        classes.add(c);
    }

    public static <T extends Comparable<T>> void assertTypeValid(Operators.Column<T> foundColumn, PrimitiveType.PrimitiveTypeName primitiveType) {
        Class<T> foundColumnType = foundColumn.getColumnType();
        ColumnPath columnPath = foundColumn.getColumnPath();
        Set<PrimitiveType.PrimitiveTypeName> validTypeDescriptors = classToParquetType.get(foundColumnType);
        if (validTypeDescriptors == null) {
            StringBuilder message = new StringBuilder();
            message.append("Column ").append(columnPath.toDotString()).append(" was declared as type: ").append(foundColumnType.getName()).append(" which is not supported in FilterPredicates.");
            Set<Class<?>> supportedTypes = parquetTypeToClass.get((Object)primitiveType);
            if (supportedTypes != null) {
                message.append(" Supported types for this column are: ").append(supportedTypes);
            } else {
                message.append(" There are no supported types for columns of " + (Object)((Object)primitiveType));
            }
            throw new IllegalArgumentException(message.toString());
        }
        if (!validTypeDescriptors.contains((Object)primitiveType)) {
            StringBuilder message = new StringBuilder();
            message.append("FilterPredicate column: ").append(columnPath.toDotString()).append("'s declared type (").append(foundColumnType.getName()).append(") does not match the schema found in file metadata. Column ").append(columnPath.toDotString()).append(" is of type: ").append((Object)primitiveType).append("\nValid types for this column are: ").append(parquetTypeToClass.get((Object)primitiveType));
            throw new IllegalArgumentException(message.toString());
        }
    }

    static {
        for (PrimitiveType.PrimitiveTypeName t2 : PrimitiveType.PrimitiveTypeName.values()) {
            Class<?> c = t2.javaType;
            if (c.isPrimitive()) {
                c = PrimitiveToBoxedClass.get(c);
            }
            ValidTypeMap.add(c, t2);
        }
    }
}

