/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.api.java.utils.OptionType;
import org.apache.flink.api.java.utils.RequiredParametersException;

@Deprecated
public class Option {
    private String longName;
    private String shortName;
    private String defaultValue;
    private Set<String> choices;
    private String helpText;
    private OptionType type = OptionType.STRING;

    public Option(String name) {
        this.longName = name;
        this.choices = new HashSet<String>();
    }

    public Option alt(String shortName) {
        this.shortName = shortName;
        return this;
    }

    public Option type(OptionType type) {
        this.type = type;
        return this;
    }

    public Option defaultValue(String defaultValue) throws RequiredParametersException {
        if (this.choices.isEmpty()) {
            return this.setDefaultValue(defaultValue);
        }
        if (this.choices.contains(defaultValue)) {
            return this.setDefaultValue(defaultValue);
        }
        throw new RequiredParametersException("Default value " + defaultValue + " is not in the list of valid values for option " + this.longName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option choices(String ... choices) throws RequiredParametersException {
        if (this.defaultValue != null) {
            if (!Arrays.asList(choices).contains(this.defaultValue)) throw new RequiredParametersException("Valid values for option " + this.longName + " do not contain defined default value " + this.defaultValue);
            Collections.addAll(this.choices, choices);
            return this;
        } else {
            Collections.addAll(this.choices, choices);
        }
        return this;
    }

    public Option help(String helpText) {
        this.helpText = helpText;
        return this;
    }

    public String getName() {
        return this.longName;
    }

    public boolean hasAlt() {
        return this.shortName != null;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public OptionType getType() {
        return this.type;
    }

    public String getAlt() {
        return this.shortName;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public Set<String> getChoices() {
        return this.choices;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    private Option setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public boolean isCastableToDefinedType(String value) {
        switch (this.type) {
            case INTEGER: {
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
                return true;
            }
            case LONG: {
                try {
                    Long.parseLong(value);
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
                return true;
            }
            case FLOAT: {
                try {
                    Float.parseFloat(value);
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
                return true;
            }
            case DOUBLE: {
                try {
                    Double.parseDouble(value);
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
                return true;
            }
            case BOOLEAN: {
                return Objects.equals(value, "true") || Objects.equals(value, "false");
            }
            case STRING: {
                return true;
            }
        }
        throw new IllegalStateException("Invalid value for OptionType " + (Object)((Object)this.type) + " for option " + this.longName);
    }
}

