/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.schedule;

import java.util.List;
import java.util.Optional;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.schedule.ScheduleEngineClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScheduleClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduleClientFactory.class);
    @Autowired
    List<ScheduleEngineClient> scheduleEngineClients;

    public ScheduleEngineClient getInstance(String scheduleEngineName) {
        Optional<ScheduleEngineClient> optScheduleClient = this.scheduleEngineClients.stream().filter(t -> t.accept(scheduleEngineName)).findFirst();
        if (!optScheduleClient.isPresent()) {
            LOGGER.warn("Schedule engine client not found for {} ", (Object)scheduleEngineName);
            throw new BusinessException(ErrorCodeEnum.SCHEDULE_ENGINE_NOT_SUPPORTED, String.format(ErrorCodeEnum.SCHEDULE_ENGINE_NOT_SUPPORTED.getMessage(), scheduleEngineName));
        }
        LOGGER.info("Get schedule engine client success for {}", (Object)scheduleEngineName);
        return optScheduleClient.get();
    }
}

