/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.schedule.airflow.config;

import java.net.URL;
import javax.annotation.PostConstruct;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.schedule.airflow.AirflowServerClient;
import org.apache.inlong.manager.schedule.airflow.interceptor.AirflowAuthInterceptor;
import org.apache.inlong.manager.schedule.airflow.interceptor.LoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AirflowConfig
extends ClientConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AirflowConfig.class);
    @Value(value="${schedule.engine.inlong.manager.url:http://127.0.0.1:8083}")
    private String inlongManagerUrl;
    private String inlongManagerHost;
    private int inlongManagerPort;
    @Value(value="${default.admin.user:admin}")
    private String inlongUsername;
    @Value(value="${default.admin.password:inlong}")
    private String inlongPassword;
    @Value(value="${schedule.engine.airflow.connection.id:inlong_connection}")
    private String connectionId;
    @Value(value="${schedule.engine.airflow.cleaner.id:dag_cleaner}")
    private String dagCleanerId;
    @Value(value="${schedule.engine.airflow.creator.id:dag_creator}")
    private String dagCreatorId;
    @Value(value="${schedule.engine.airflow.username:airflow}")
    private String airflowUsername;
    @Value(value="${schedule.engine.airflow.password:airflow}")
    private String airflowPassword;
    @Value(value="${schedule.engine.airflow.baseUrl:http://localhost:8080/}")
    private String baseUrl;

    @PostConstruct
    public void init() {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.inlongManagerUrl)) {
                URL url = new URL(this.inlongManagerUrl);
                this.inlongManagerHost = url.getHost();
                this.inlongManagerPort = url.getPort();
                if (this.inlongManagerPort == -1) {
                    this.inlongManagerPort = 8083;
                }
            }
            LOGGER.info("Init AirflowConfig success for manager url ={}", (Object)this.inlongManagerUrl);
        }
        catch (Exception e) {
            LOGGER.error("Init AirflowConfig failed for manager url={}: ", (Object)this.inlongManagerUrl, (Object)e);
        }
    }

    @Bean
    public OkHttpClient okHttpClient() {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new AirflowAuthInterceptor(this.getAirflowUsername(), this.getAirflowPassword())).addInterceptor((Interceptor)new LoggingInterceptor()).connectTimeout((long)this.getConnectTimeout(), this.getTimeUnit()).readTimeout((long)this.getReadTimeout(), this.getTimeUnit()).writeTimeout((long)this.getWriteTimeout(), this.getTimeUnit()).retryOnConnectionFailure(true).build();
    }

    @Bean
    public AirflowServerClient airflowServerClient(OkHttpClient okHttpClient, AirflowConfig airflowConfig) {
        return new AirflowServerClient(okHttpClient, airflowConfig);
    }

    public String getInlongManagerUrl() {
        return this.inlongManagerUrl;
    }

    public String getInlongManagerHost() {
        return this.inlongManagerHost;
    }

    public int getInlongManagerPort() {
        return this.inlongManagerPort;
    }

    public String getInlongUsername() {
        return this.inlongUsername;
    }

    public String getInlongPassword() {
        return this.inlongPassword;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getDagCleanerId() {
        return this.dagCleanerId;
    }

    public String getDagCreatorId() {
        return this.dagCreatorId;
    }

    public String getAirflowUsername() {
        return this.airflowUsername;
    }

    public String getAirflowPassword() {
        return this.airflowPassword;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setInlongManagerUrl(String inlongManagerUrl) {
        this.inlongManagerUrl = inlongManagerUrl;
    }

    public void setInlongManagerHost(String inlongManagerHost) {
        this.inlongManagerHost = inlongManagerHost;
    }

    public void setInlongManagerPort(int inlongManagerPort) {
        this.inlongManagerPort = inlongManagerPort;
    }

    public void setInlongUsername(String inlongUsername) {
        this.inlongUsername = inlongUsername;
    }

    public void setInlongPassword(String inlongPassword) {
        this.inlongPassword = inlongPassword;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public void setDagCleanerId(String dagCleanerId) {
        this.dagCleanerId = dagCleanerId;
    }

    public void setDagCreatorId(String dagCreatorId) {
        this.dagCreatorId = dagCreatorId;
    }

    public void setAirflowUsername(String airflowUsername) {
        this.airflowUsername = airflowUsername;
    }

    public void setAirflowPassword(String airflowPassword) {
        this.airflowPassword = airflowPassword;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String toString() {
        return "AirflowConfig(inlongManagerUrl=" + this.getInlongManagerUrl() + ", inlongManagerHost=" + this.getInlongManagerHost() + ", inlongManagerPort=" + this.getInlongManagerPort() + ", inlongUsername=" + this.getInlongUsername() + ", inlongPassword=" + this.getInlongPassword() + ", connectionId=" + this.getConnectionId() + ", dagCleanerId=" + this.getDagCleanerId() + ", dagCreatorId=" + this.getDagCreatorId() + ", airflowUsername=" + this.getAirflowUsername() + ", airflowPassword=" + this.getAirflowPassword() + ", baseUrl=" + this.getBaseUrl() + ")";
    }

    public AirflowConfig() {
    }

    public AirflowConfig(String inlongManagerUrl, String inlongManagerHost, int inlongManagerPort, String inlongUsername, String inlongPassword, String connectionId, String dagCleanerId, String dagCreatorId, String airflowUsername, String airflowPassword, String baseUrl) {
        this.inlongManagerUrl = inlongManagerUrl;
        this.inlongManagerHost = inlongManagerHost;
        this.inlongManagerPort = inlongManagerPort;
        this.inlongUsername = inlongUsername;
        this.inlongPassword = inlongPassword;
        this.connectionId = connectionId;
        this.dagCleanerId = dagCleanerId;
        this.dagCreatorId = dagCreatorId;
        this.airflowUsername = airflowUsername;
        this.airflowPassword = airflowPassword;
        this.baseUrl = baseUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AirflowConfig)) {
            return false;
        }
        AirflowConfig other = (AirflowConfig)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getInlongManagerPort() != other.getInlongManagerPort()) {
            return false;
        }
        String this$inlongManagerUrl = this.getInlongManagerUrl();
        String other$inlongManagerUrl = other.getInlongManagerUrl();
        if (this$inlongManagerUrl == null ? other$inlongManagerUrl != null : !this$inlongManagerUrl.equals(other$inlongManagerUrl)) {
            return false;
        }
        String this$inlongManagerHost = this.getInlongManagerHost();
        String other$inlongManagerHost = other.getInlongManagerHost();
        if (this$inlongManagerHost == null ? other$inlongManagerHost != null : !this$inlongManagerHost.equals(other$inlongManagerHost)) {
            return false;
        }
        String this$inlongUsername = this.getInlongUsername();
        String other$inlongUsername = other.getInlongUsername();
        if (this$inlongUsername == null ? other$inlongUsername != null : !this$inlongUsername.equals(other$inlongUsername)) {
            return false;
        }
        String this$inlongPassword = this.getInlongPassword();
        String other$inlongPassword = other.getInlongPassword();
        if (this$inlongPassword == null ? other$inlongPassword != null : !this$inlongPassword.equals(other$inlongPassword)) {
            return false;
        }
        String this$connectionId = this.getConnectionId();
        String other$connectionId = other.getConnectionId();
        if (this$connectionId == null ? other$connectionId != null : !this$connectionId.equals(other$connectionId)) {
            return false;
        }
        String this$dagCleanerId = this.getDagCleanerId();
        String other$dagCleanerId = other.getDagCleanerId();
        if (this$dagCleanerId == null ? other$dagCleanerId != null : !this$dagCleanerId.equals(other$dagCleanerId)) {
            return false;
        }
        String this$dagCreatorId = this.getDagCreatorId();
        String other$dagCreatorId = other.getDagCreatorId();
        if (this$dagCreatorId == null ? other$dagCreatorId != null : !this$dagCreatorId.equals(other$dagCreatorId)) {
            return false;
        }
        String this$airflowUsername = this.getAirflowUsername();
        String other$airflowUsername = other.getAirflowUsername();
        if (this$airflowUsername == null ? other$airflowUsername != null : !this$airflowUsername.equals(other$airflowUsername)) {
            return false;
        }
        String this$airflowPassword = this.getAirflowPassword();
        String other$airflowPassword = other.getAirflowPassword();
        if (this$airflowPassword == null ? other$airflowPassword != null : !this$airflowPassword.equals(other$airflowPassword)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        return !(this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AirflowConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getInlongManagerPort();
        String $inlongManagerUrl = this.getInlongManagerUrl();
        result = result * 59 + ($inlongManagerUrl == null ? 43 : $inlongManagerUrl.hashCode());
        String $inlongManagerHost = this.getInlongManagerHost();
        result = result * 59 + ($inlongManagerHost == null ? 43 : $inlongManagerHost.hashCode());
        String $inlongUsername = this.getInlongUsername();
        result = result * 59 + ($inlongUsername == null ? 43 : $inlongUsername.hashCode());
        String $inlongPassword = this.getInlongPassword();
        result = result * 59 + ($inlongPassword == null ? 43 : $inlongPassword.hashCode());
        String $connectionId = this.getConnectionId();
        result = result * 59 + ($connectionId == null ? 43 : $connectionId.hashCode());
        String $dagCleanerId = this.getDagCleanerId();
        result = result * 59 + ($dagCleanerId == null ? 43 : $dagCleanerId.hashCode());
        String $dagCreatorId = this.getDagCreatorId();
        result = result * 59 + ($dagCreatorId == null ? 43 : $dagCreatorId.hashCode());
        String $airflowUsername = this.getAirflowUsername();
        result = result * 59 + ($airflowUsername == null ? 43 : $airflowUsername.hashCode());
        String $airflowPassword = this.getAirflowPassword();
        result = result * 59 + ($airflowPassword == null ? 43 : $airflowPassword.hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        return result;
    }
}

