/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbc.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import ru.yandex.clickhouse.jdbc.parser.LanguageType;
import ru.yandex.clickhouse.jdbc.parser.OperationType;
import ru.yandex.clickhouse.jdbc.parser.StatementType;

public class ClickHouseSqlStatement {
    public static final String DEFAULT_DATABASE = "system";
    public static final String DEFAULT_TABLE = "unknown";
    public static final List<Integer> DEFAULT_PARAMETERS = Collections.emptyList();
    public static final Map<String, Integer> DEFAULT_POSITIONS = Collections.emptyMap();
    public static final String KEYWORD_DATABASE = "DATABASE";
    public static final String KEYWORD_EXISTS = "EXISTS";
    public static final String KEYWORD_FORMAT = "FORMAT";
    public static final String KEYWORD_REPLACE = "REPLACE";
    public static final String KEYWORD_TOTALS = "TOTALS";
    public static final String KEYWORD_VALUES = "VALUES";
    private final String sql;
    private final StatementType stmtType;
    private final String cluster;
    private final String database;
    private final String table;
    private final String format;
    private final String outfile;
    private final List<Integer> parameters;
    private final Map<String, Integer> positions;

    public ClickHouseSqlStatement(String sql) {
        this(sql, StatementType.UNKNOWN, null, null, null, null, null, null, null);
    }

    public ClickHouseSqlStatement(String sql, StatementType stmtType) {
        this(sql, stmtType, null, null, null, null, null, null, null);
    }

    public ClickHouseSqlStatement(String sql, StatementType stmtType, String cluster, String database, String table, String format, String outfile, List<Integer> parameters, Map<String, Integer> positions) {
        this.sql = sql;
        this.stmtType = stmtType;
        this.cluster = cluster;
        this.database = database;
        this.table = table == null || table.isEmpty() ? DEFAULT_TABLE : table;
        this.format = format;
        this.outfile = outfile;
        this.parameters = parameters != null && parameters.size() > 0 ? Collections.unmodifiableList(parameters) : DEFAULT_PARAMETERS;
        if (positions != null && positions.size() > 0) {
            HashMap<String, Integer> p = new HashMap<String, Integer>();
            for (Map.Entry<String, Integer> e : positions.entrySet()) {
                String keyword = e.getKey();
                Integer position = e.getValue();
                if (keyword == null || position == null) continue;
                p.put(keyword.toUpperCase(Locale.ROOT), position);
            }
            this.positions = Collections.unmodifiableMap(p);
        } else {
            this.positions = DEFAULT_POSITIONS;
        }
    }

    public String getSQL() {
        return this.sql;
    }

    public boolean isRecognized() {
        return this.stmtType != StatementType.UNKNOWN;
    }

    public boolean isDDL() {
        return this.stmtType.getLanguageType() == LanguageType.DDL;
    }

    public boolean isDML() {
        return this.stmtType.getLanguageType() == LanguageType.DML;
    }

    public boolean isQuery() {
        return this.stmtType.getOperationType() == OperationType.READ && !this.hasOutfile();
    }

    public boolean isMutation() {
        return this.stmtType.getOperationType() == OperationType.WRITE || this.hasOutfile();
    }

    public boolean isIdemponent() {
        boolean result;
        boolean bl = result = this.stmtType.isIdempotent() && !this.hasOutfile();
        if (!result) {
            switch (this.stmtType) {
                case ATTACH: 
                case CREATE: 
                case DETACH: 
                case DROP: {
                    result = this.positions.containsKey(KEYWORD_EXISTS) || this.positions.containsKey(KEYWORD_REPLACE);
                    break;
                }
            }
        }
        return result;
    }

    public LanguageType getLanguageType() {
        return this.stmtType.getLanguageType();
    }

    public OperationType getOperationType() {
        return this.stmtType.getOperationType();
    }

    public StatementType getStatementType() {
        return this.stmtType;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getDatabaseOrDefault(String database) {
        return this.database == null ? (database == null ? DEFAULT_DATABASE : database) : this.database;
    }

    public String getTable() {
        return this.table;
    }

    public String getFormat() {
        return this.format;
    }

    public String getOutfile() {
        return this.outfile;
    }

    public boolean containsKeyword(String keyword) {
        if (keyword == null || keyword.isEmpty()) {
            return false;
        }
        return this.positions.containsKey(keyword.toUpperCase(Locale.ROOT));
    }

    public boolean hasFormat() {
        return this.format != null && !this.format.isEmpty();
    }

    public boolean hasOutfile() {
        return this.outfile != null && !this.outfile.isEmpty();
    }

    public boolean hasWithTotals() {
        return this.positions.containsKey(KEYWORD_TOTALS);
    }

    public boolean hasValues() {
        return this.positions.containsKey(KEYWORD_VALUES);
    }

    public List<Integer> getParameters() {
        return this.parameters;
    }

    public int getStartPosition(String keyword) {
        Integer p;
        int position = -1;
        if (!this.positions.isEmpty() && keyword != null && (p = this.positions.get(keyword.toUpperCase(Locale.ROOT))) != null) {
            position = p;
        }
        return position;
    }

    public int getEndPosition(String keyword) {
        int position = this.getStartPosition(keyword);
        return position != -1 && keyword != null ? position + keyword.length() : position;
    }

    public Map<String, Integer> getPositions() {
        return this.positions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.stmtType.name()).append(']').append(" cluster=").append(this.cluster).append(", database=").append(this.database).append(", table=").append(this.table).append(", format=").append(this.format).append(", outfile=").append(this.outfile).append(", parameters=").append(this.parameters).append(", positions=").append(this.positions).append("\nSQL:\n").append(this.sql);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cluster == null ? 0 : this.cluster.hashCode());
        result = 31 * result + (this.database == null ? 0 : this.database.hashCode());
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.outfile == null ? 0 : this.outfile.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.positions == null ? 0 : this.positions.hashCode());
        result = 31 * result + (this.sql == null ? 0 : this.sql.hashCode());
        result = 31 * result + (this.stmtType == null ? 0 : this.stmtType.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseSqlStatement other = (ClickHouseSqlStatement)obj;
        if (this.cluster == null ? other.cluster != null : !this.cluster.equals(other.cluster)) {
            return false;
        }
        if (this.database == null ? other.database != null : !this.database.equals(other.database)) {
            return false;
        }
        if (this.format == null ? other.format != null : !this.format.equals(other.format)) {
            return false;
        }
        if (this.outfile == null ? other.outfile != null : !this.outfile.equals(other.outfile)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        if (this.positions == null ? other.positions != null : !this.positions.equals(other.positions)) {
            return false;
        }
        if (this.sql == null ? other.sql != null : !this.sql.equals(other.sql)) {
            return false;
        }
        if (this.stmtType != other.stmtType) {
            return false;
        }
        return !(this.table == null ? other.table != null : !this.table.equals(other.table));
    }
}

