/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response.parser;

import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import ru.yandex.clickhouse.domain.ClickHouseDataType;
import ru.yandex.clickhouse.response.ByteFragment;
import ru.yandex.clickhouse.response.ClickHouseColumnInfo;
import ru.yandex.clickhouse.response.parser.ClickHouseValueParser;

final class ClickHouseMapParser
extends ClickHouseValueParser<Map> {
    private static ClickHouseMapParser instance;

    static ClickHouseMapParser getInstance() {
        if (instance == null) {
            instance = new ClickHouseMapParser();
        }
        return instance;
    }

    private ClickHouseMapParser() {
    }

    int readPart(ClickHouseDataType type, String str, int startPosition, int len, StringBuilder sb, char stopChar) {
        ArrayDeque<Character> stack = new ArrayDeque<Character>();
        stack.push(Character.valueOf('\u0000'));
        char lastChar = '\u0000';
        block7: for (int i = startPosition; i < len; ++i) {
            startPosition = i;
            char ch = str.charAt(startPosition);
            if (lastChar == '\u0000') {
                if (Character.isWhitespace(ch)) continue;
                if (ch == stopChar) break;
                switch (ch) {
                    case '\'': {
                        if (lastChar != '\u0000') {
                            stack.push(Character.valueOf(lastChar));
                        }
                        lastChar = ch;
                        if (type == ClickHouseDataType.String) continue block7;
                        sb.append(ch);
                        break;
                    }
                    case '{': {
                        if (lastChar != '\u0000') {
                            stack.push(Character.valueOf(lastChar));
                        }
                        lastChar = '}';
                        sb.append(ch);
                        break;
                    }
                    case '(': {
                        if (lastChar != '\u0000') {
                            stack.push(Character.valueOf(lastChar));
                        }
                        lastChar = ')';
                        sb.append(ch);
                        break;
                    }
                    case '[': {
                        if (lastChar != '\u0000') {
                            stack.push(Character.valueOf(lastChar));
                        }
                        lastChar = ']';
                        sb.append(ch);
                        break;
                    }
                    case '}': {
                        return i + 1;
                    }
                    default: {
                        sb.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (lastChar == '\'') {
                if (ch != '\'' || type != ClickHouseDataType.String) {
                    sb.append(ch);
                }
                if (i + 1 >= len) continue;
                char nextChar = str.charAt(i + 1);
                if (ch == '\\') {
                    sb.append(nextChar);
                    ++i;
                    continue;
                }
                if (ch == '\'' && nextChar == ch) {
                    sb.append(ch).append(nextChar);
                    ++i;
                    continue;
                }
                if (ch != '\'') continue;
                lastChar = ((Character)stack.pop()).charValue();
                continue;
            }
            if (lastChar != '}' && lastChar != ')' && lastChar != 93) continue;
            if (ch == lastChar) {
                lastChar = ((Character)stack.pop()).charValue();
            }
            sb.append(ch);
        }
        return startPosition;
    }

    @Override
    public Map parse(ByteFragment value, ClickHouseColumnInfo columnInfo, TimeZone resultTimeZone) throws SQLException {
        int len;
        if (value.isNull()) {
            return null;
        }
        ClickHouseColumnInfo keyInfo = Objects.requireNonNull(columnInfo.getKeyInfo());
        ClickHouseColumnInfo valueInfo = Objects.requireNonNull(columnInfo.getValueInfo());
        ClickHouseValueParser<?> keyParser = ClickHouseValueParser.getParser(keyInfo.getClickHouseDataType().getJavaClass());
        ClickHouseValueParser<?> valueParser = ClickHouseValueParser.getParser(valueInfo.getClickHouseDataType().getJavaClass());
        String str = value.asString();
        int n = len = str == null ? 0 : str.length();
        if (len < 2) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        int part = -1;
        StringBuilder sb = new StringBuilder();
        Object k = null;
        Object v = null;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (part == -1) {
                if (ch == '{') {
                    part = 0;
                    continue;
                }
                throw new IllegalArgumentException("Invalid map. Expect '{' but we got '" + ch + "' at " + i);
            }
            if (ch == '}') break;
            if (part == 0) {
                i = this.readPart(keyInfo.getClickHouseDataType(), str, i, len, sb, ':');
                k = keyParser.parse(ByteFragment.fromString(sb.toString()), keyInfo, resultTimeZone);
                part = 1;
                sb.setLength(0);
                continue;
            }
            i = this.readPart(valueInfo.getClickHouseDataType(), str, i, len, sb, ',');
            v = valueParser.parse(ByteFragment.fromString(sb.toString()), valueInfo, resultTimeZone);
            map.put(k, valueInfo.isArray() && v != null ? ((Array)v).getArray() : v);
            part = 0;
            sb.setLength(0);
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    protected Map getDefaultValue() {
        return Collections.emptyMap();
    }
}

