/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster.node;

import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.service.cluster.node.InlongClusterNodeInstallOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InlongClusterNodeInstallOperatorFactory {
    @Autowired
    private List<InlongClusterNodeInstallOperator> operatorList;

    public InlongClusterNodeInstallOperator getInstance(String clusterType) {
        return this.operatorList.stream().filter(inst -> inst.accept(clusterType)).findFirst().orElseThrow(() -> new BusinessException(ErrorCodeEnum.CLUSTER_TYPE_NOT_SUPPORTED, String.format(ErrorCodeEnum.CLUSTER_TYPE_NOT_SUPPORTED.getMessage(), clusterType)));
    }
}

