/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.consume.apply;

import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ConsumeStatus;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.ProcessEvent;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.dao.entity.InlongConsumeEntity;
import org.apache.inlong.manager.dao.mapper.InlongConsumeEntityMapper;
import org.apache.inlong.manager.pojo.workflow.form.process.ApplyConsumeProcessForm;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RejectConsumeProcessListener
implements ProcessEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RejectConsumeProcessListener.class);
    @Autowired
    private InlongConsumeEntityMapper consumeMapper;

    @Autowired
    public RejectConsumeProcessListener(InlongConsumeEntityMapper consumeMapper) {
        this.consumeMapper = consumeMapper;
    }

    public ProcessEvent event() {
        return ProcessEvent.REJECT;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        ApplyConsumeProcessForm processForm = (ApplyConsumeProcessForm)context.getProcessForm();
        InlongConsumeEntity consumeEntity = this.consumeMapper.selectById(processForm.getConsumeInfo().getId());
        consumeEntity.setStatus(ConsumeStatus.APPROVE_REJECTED.getCode());
        int rowCount = this.consumeMapper.updateByIdSelective(consumeEntity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("inlong consume has already updated, id={}, curVersion={}", (Object)consumeEntity.getId(), (Object)consumeEntity.getVersion());
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        return ListenerResult.success((String)"The consume application was rejected");
    }
}

