/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.operationlog;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.mapper.OperationLogEntityMapper;
import org.apache.inlong.manager.pojo.common.OrderFieldEnum;
import org.apache.inlong.manager.pojo.common.OrderTypeEnum;
import org.apache.inlong.manager.pojo.common.PageRequest;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.operationLog.OperationLogRequest;
import org.apache.inlong.manager.pojo.operationLog.OperationLogResponse;
import org.apache.inlong.manager.service.operationlog.OperationLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperationLogServiceImpl
implements OperationLogService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationLogServiceImpl.class);
    @Autowired
    private OperationLogEntityMapper operationLogMapper;

    @Override
    public PageResult<OperationLogResponse> listByCondition(OperationLogRequest request) {
        if (request.getPageSize() > PageRequest.MAX_PAGE_SIZE) {
            LOGGER.warn("list operation logs, change page size from {} to {}", (Object)request.getPageSize(), (Object)PageRequest.MAX_PAGE_SIZE);
            request.setPageSize(PageRequest.MAX_PAGE_SIZE.intValue());
        }
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        OrderFieldEnum.checkOrderField((PageRequest)request);
        OrderTypeEnum.checkOrderType((PageRequest)request);
        Page entityPage = (Page)this.operationLogMapper.selectByCondition(request);
        PageResult pageResult = PageResult.fromPage((Page)entityPage).map(entity -> (OperationLogResponse)CommonBeanUtils.copyProperties((Object)entity, OperationLogResponse::new));
        return pageResult;
    }
}

