/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink;

import java.util.List;
import java.util.Optional;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.service.resource.sink.SinkResourceOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SinkResourceOperatorFactory {
    @Autowired
    private List<SinkResourceOperator> operatorList;

    public SinkResourceOperator getInstance(String sinkType) {
        Optional<SinkResourceOperator> instance = this.operatorList.stream().filter(inst -> inst.accept(sinkType)).findFirst();
        if (!instance.isPresent()) {
            throw new BusinessException(ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT, String.format(ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT.getMessage(), sinkType));
        }
        return instance.get();
    }
}

