/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.oracle;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.pojo.sink.oracle.OracleColumnInfo;
import org.apache.inlong.manager.pojo.sink.oracle.OracleTableInfo;
import org.apache.inlong.manager.service.resource.sink.oracle.OracleSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleJdbcUtils {
    private static final String ORACLE_JDBC_PREFIX = "jdbc:oracle";
    private static final String ORACLE_DRIVER_CLASS = "oracle.jdbc.driver.OracleDriver";
    private static final Logger LOG = LoggerFactory.getLogger(OracleJdbcUtils.class);

    public static Connection getConnection(String url, String user, String password) throws Exception {
        Connection conn;
        if (StringUtils.isBlank((CharSequence)url) || !url.startsWith(ORACLE_JDBC_PREFIX)) {
            throw new Exception("Oracle server URL was invalid, it should start with jdbc:oracle");
        }
        try {
            Class.forName(ORACLE_DRIVER_CLASS);
            conn = DriverManager.getConnection(url, user, password);
        }
        catch (Exception e) {
            String errorMsg = "get Oracle connection error, please check Oracle JDBC url, username or password!";
            LOG.error("get Oracle connection error, please check Oracle JDBC url, username or password!", (Throwable)e);
            throw new Exception("get Oracle connection error, please check Oracle JDBC url, username or password! other error msg: " + e.getMessage());
        }
        if (Objects.isNull(conn)) {
            throw new Exception("get Oracle connection failed, please contact administrator.");
        }
        LOG.info("get Oracle connection success, url={}", (Object)url);
        return conn;
    }

    public static void executeSql(Connection conn, String sql) throws Exception {
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sql);
        }
        LOG.info("execute sql [{}] success", (Object)sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSqlBatch(Connection conn, List<String> sqls) throws Exception {
        conn.setAutoCommit(false);
        try (Statement stmt = conn.createStatement();){
            for (String entry : sqls) {
                stmt.execute(entry);
            }
            conn.commit();
            LOG.info("execute batch sql [{}] success", sqls);
        }
        finally {
            conn.setAutoCommit(true);
        }
    }

    public static void createTable(Connection conn, OracleTableInfo tableInfo) throws Exception {
        if (OracleJdbcUtils.checkTablesExist(conn, tableInfo.getUserName(), tableInfo.getTableName())) {
            LOG.info("The table [{}] are exists", (Object)tableInfo.getTableName());
        } else {
            List<String> createTableSqls = OracleSqlBuilder.buildCreateTableSql(tableInfo);
            OracleJdbcUtils.executeSqlBatch(conn, createTableSqls);
            LOG.info("execute sql [{}] success", createTableSqls);
        }
    }

    public static boolean checkTablesExist(Connection conn, String userName, String tableName) throws Exception {
        boolean result = false;
        String checkTableSql = OracleSqlBuilder.getCheckTable(userName, tableName);
        try (Statement statement = conn.createStatement();
             ResultSet resultSet = statement.executeQuery(checkTableSql);){
            int size;
            if (Objects.nonNull(resultSet) && resultSet.next() && (size = resultSet.getInt(1)) > 0) {
                result = true;
            }
        }
        LOG.info("check table exist for username={} table={}, result={}", new Object[]{userName, tableName, result});
        return result;
    }

    public static boolean checkColumnExist(Connection conn, String tableName, String column) throws Exception {
        boolean result = false;
        String checkColumnSql = OracleSqlBuilder.getCheckColumn(tableName, column);
        try (Statement statement = conn.createStatement();
             ResultSet resultSet = statement.executeQuery(checkColumnSql);){
            int count;
            if (Objects.nonNull(resultSet) && resultSet.next() && (count = resultSet.getInt(1)) > 0) {
                result = true;
            }
        }
        LOG.info("check column exist for table={}, column={}, result={}", new Object[]{tableName, column, result});
        return result;
    }

    public static List<OracleColumnInfo> getColumns(Connection conn, String tableName) throws Exception {
        String querySql = OracleSqlBuilder.buildDescTableSql(tableName);
        ArrayList<OracleColumnInfo> columnList = new ArrayList<OracleColumnInfo>();
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(querySql);){
            while (rs.next()) {
                OracleColumnInfo columnInfo = new OracleColumnInfo(rs.getString(1), rs.getString(2), rs.getString(3));
                columnList.add(columnInfo);
            }
        }
        return columnList;
    }

    public static void addColumns(Connection conn, String tableName, List<OracleColumnInfo> columns) throws Exception {
        ArrayList<OracleColumnInfo> columnInfos = new ArrayList<OracleColumnInfo>();
        for (OracleColumnInfo columnInfo : columns) {
            if (OracleJdbcUtils.checkColumnExist(conn, tableName, columnInfo.getName())) continue;
            columnInfos.add(columnInfo);
        }
        List<String> addColumnSql = OracleSqlBuilder.buildAddColumnsSql(tableName, columnInfos);
        OracleJdbcUtils.executeSqlBatch(conn, addColumnSql);
    }
}

