/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.stream;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.common.enums.ProcessStatus;
import org.apache.inlong.manager.common.enums.StreamStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.threadPool.VisiableThreadPoolTaskExecutor;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.pojo.workflow.WorkflowResult;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.StreamResourceProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InlongStreamProcessService {
    private static final Logger log = LoggerFactory.getLogger(InlongStreamProcessService.class);
    private static final ExecutorService EXECUTOR_SERVICE = new VisiableThreadPoolTaskExecutor(10, 20, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue(10000), new ThreadFactoryBuilder().setNameFormat("inlong-stream-process-%s").build(), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongStreamService streamService;
    @Autowired
    private WorkflowService workflowService;

    public boolean startProcess(String groupId, String streamId, String operator, boolean sync) {
        log.info("begin to start stream process for groupId={} streamId={}", (Object)groupId, (Object)streamId);
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        Preconditions.expectNotNull((Object)groupInfo, (String)ErrorCodeEnum.GROUP_NOT_FOUND.getMessage());
        GroupStatus groupStatus = GroupStatus.forCode((int)groupInfo.getStatus());
        if (groupStatus != GroupStatus.CONFIG_SUCCESSFUL) {
            throw new BusinessException(String.format("group status=%s not support start stream for groupId=%s", groupStatus, groupId));
        }
        InlongStreamInfo streamInfo = this.streamService.get(groupId, streamId);
        Preconditions.expectNotNull((Object)streamInfo, (String)ErrorCodeEnum.STREAM_NOT_FOUND.getMessage());
        StreamStatus status = StreamStatus.forCode((int)streamInfo.getStatus());
        if (status == StreamStatus.CONFIG_ING) {
            log.warn("stream status={}, not need restart for groupId={} streamId={}", new Object[]{status, groupId, streamId});
            return true;
        }
        if (StreamStatus.notAllowedUpdate((StreamStatus)status)) {
            String errMsg = String.format("stream status=%s not support start stream for groupId=%s streamId=%s", status, groupId, streamId);
            log.error(errMsg);
            throw new BusinessException(errMsg);
        }
        StreamResourceProcessForm processForm = StreamResourceProcessForm.getProcessForm((InlongGroupInfo)groupInfo, (InlongStreamInfo)streamInfo, (GroupOperateType)GroupOperateType.INIT);
        ProcessName processName = ProcessName.CREATE_STREAM_RESOURCE;
        if (sync) {
            WorkflowResult workflowResult = this.workflowService.start(processName, operator, (ProcessForm)processForm);
            ProcessStatus processStatus = workflowResult.getProcessInfo().getStatus();
            return processStatus == ProcessStatus.COMPLETED;
        }
        UserInfo userInfo = LoginUserUtils.getLoginUser();
        EXECUTOR_SERVICE.execute(() -> this.workflowService.startAsync(processName, userInfo, (ProcessForm)processForm));
        return true;
    }

    public boolean suspendProcess(String groupId, String streamId, String operator, boolean sync) {
        log.info("begin to suspend stream process for groupId={} streamId={}", (Object)groupId, (Object)streamId);
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        Preconditions.expectNotNull((Object)groupInfo, (String)ErrorCodeEnum.GROUP_NOT_FOUND.getMessage());
        GroupStatus groupStatus = GroupStatus.forCode((int)groupInfo.getStatus());
        if (!GroupStatus.allowedSuspend((GroupStatus)groupStatus)) {
            throw new BusinessException(String.format("group status=%s not support suspend stream for groupId=%s", groupStatus, groupId));
        }
        InlongStreamInfo streamInfo = this.streamService.get(groupId, streamId);
        Preconditions.expectNotNull((Object)streamInfo, (String)ErrorCodeEnum.STREAM_NOT_FOUND.getMessage());
        StreamStatus status = StreamStatus.forCode((int)streamInfo.getStatus());
        if (status == StreamStatus.CONFIG_OFFLINE_SUCCESSFUL || status == StreamStatus.CONFIG_OFFLINE_ING) {
            log.warn("groupId={}, streamId={} is already in {}", new Object[]{groupId, streamId, status});
            return true;
        }
        if (status != StreamStatus.CONFIG_SUCCESSFUL) {
            throw new BusinessException(String.format("stream status=%s not support suspend stream for groupId=%s streamId=%s", status, groupId, streamId));
        }
        StreamResourceProcessForm processForm = StreamResourceProcessForm.getProcessForm((InlongGroupInfo)groupInfo, (InlongStreamInfo)streamInfo, (GroupOperateType)GroupOperateType.SUSPEND);
        ProcessName processName = ProcessName.SUSPEND_STREAM_RESOURCE;
        if (sync) {
            WorkflowResult workflowResult = this.workflowService.start(processName, operator, (ProcessForm)processForm);
            ProcessStatus processStatus = workflowResult.getProcessInfo().getStatus();
            return processStatus == ProcessStatus.COMPLETED;
        }
        UserInfo userInfo = LoginUserUtils.getLoginUser();
        EXECUTOR_SERVICE.execute(() -> this.workflowService.startAsync(processName, userInfo, (ProcessForm)processForm));
        return true;
    }

    public boolean restartProcess(String groupId, String streamId, String operator, boolean sync) {
        log.info("begin to restart stream process for groupId={} streamId={}", (Object)groupId, (Object)streamId);
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        Preconditions.expectNotNull((Object)groupInfo, (String)ErrorCodeEnum.GROUP_NOT_FOUND.getMessage());
        GroupStatus groupStatus = GroupStatus.forCode((int)groupInfo.getStatus());
        if (groupStatus != GroupStatus.CONFIG_SUCCESSFUL) {
            throw new BusinessException(String.format("group status=%s not support restart stream for groupId=%s", groupStatus, groupId));
        }
        InlongStreamInfo streamInfo = this.streamService.get(groupId, streamId);
        Preconditions.expectNotNull((Object)streamInfo, (String)ErrorCodeEnum.STREAM_NOT_FOUND.getMessage());
        StreamStatus status = StreamStatus.forCode((int)streamInfo.getStatus());
        if (status == StreamStatus.CONFIG_ONLINE_ING) {
            log.warn("inlong stream was already in {} for groupId={}, streamId={}", new Object[]{status, groupId, streamId});
            return true;
        }
        if (status != StreamStatus.CONFIG_OFFLINE_SUCCESSFUL) {
            throw new BusinessException(String.format("stream status=%s not support restart stream for groupId=%s streamId=%s", status, groupId, streamId));
        }
        StreamResourceProcessForm processForm = StreamResourceProcessForm.getProcessForm((InlongGroupInfo)groupInfo, (InlongStreamInfo)streamInfo, (GroupOperateType)GroupOperateType.RESTART);
        ProcessName processName = ProcessName.RESTART_STREAM_RESOURCE;
        if (sync) {
            WorkflowResult workflowResult = this.workflowService.start(processName, operator, (ProcessForm)processForm);
            ProcessStatus processStatus = workflowResult.getProcessInfo().getStatus();
            return processStatus == ProcessStatus.COMPLETED;
        }
        UserInfo userInfo = LoginUserUtils.getLoginUser();
        EXECUTOR_SERVICE.execute(() -> this.workflowService.startAsync(processName, userInfo, (ProcessForm)processForm));
        return true;
    }

    public boolean deleteProcess(String groupId, String streamId, String operator, boolean sync) {
        log.debug("begin to delete stream process for groupId={} streamId={}", (Object)groupId, (Object)streamId);
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        if (groupInfo == null) {
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND, ErrorCodeEnum.GROUP_NOT_FOUND.getMessage() + " : " + groupId);
        }
        GroupStatus groupStatus = GroupStatus.forCode((int)groupInfo.getStatus());
        if (GroupStatus.notAllowedTransition((GroupStatus)groupStatus, (GroupStatus)GroupStatus.CONFIG_DELETING)) {
            throw new BusinessException(ErrorCodeEnum.GROUP_DELETE_NOT_ALLOWED, String.format("group status=%s not support delete stream for groupId=%s", groupStatus, groupId));
        }
        InlongStreamInfo streamInfo = this.streamService.get(groupId, streamId);
        Preconditions.expectNotNull((Object)streamInfo, (String)ErrorCodeEnum.STREAM_NOT_FOUND.getMessage());
        StreamStatus status = StreamStatus.forCode((int)streamInfo.getStatus());
        if (status == StreamStatus.DELETED || status == StreamStatus.DELETING) {
            log.debug("groupId={}, streamId={} is already in {}", new Object[]{groupId, streamId, status});
            return true;
        }
        if (StreamStatus.notAllowedDelete((StreamStatus)status)) {
            throw new BusinessException(ErrorCodeEnum.STREAM_OPT_NOT_ALLOWED, String.format("stream status=%s not support delete stream for groupId=%s streamId=%s", status, groupId, streamId));
        }
        StreamResourceProcessForm processForm = StreamResourceProcessForm.getProcessForm((InlongGroupInfo)groupInfo, (InlongStreamInfo)streamInfo, (GroupOperateType)GroupOperateType.DELETE);
        ProcessName processName = ProcessName.DELETE_STREAM_RESOURCE;
        if (sync) {
            WorkflowResult workflowResult = this.workflowService.start(processName, operator, (ProcessForm)processForm);
            ProcessStatus processStatus = workflowResult.getProcessInfo().getStatus();
            if (processStatus == ProcessStatus.COMPLETED) {
                return this.streamService.delete(groupId, streamId, operator);
            }
            return false;
        }
        UserInfo userInfo = LoginUserUtils.getLoginUser();
        EXECUTOR_SERVICE.execute(() -> {
            LoginUserUtils.setUserLoginInfo((UserInfo)userInfo);
            WorkflowResult workflowResult = this.workflowService.start(processName, operator, (ProcessForm)processForm);
            ProcessStatus processStatus = workflowResult.getProcessInfo().getStatus();
            if (processStatus == ProcessStatus.COMPLETED) {
                this.streamService.delete(groupId, streamId, operator);
            }
            LoginUserUtils.removeUserLoginInfo();
        });
        return true;
    }
}

