/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow;

import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.workflow.core.ProcessDefinitionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowDefinitionRegister {
    private static final Logger log = LoggerFactory.getLogger(WorkflowDefinitionRegister.class);
    @Autowired
    private ProcessDefinitionService processDefService;
    @Autowired
    private List<WorkflowDefinition> workflowDefinitions;

    @PostConstruct
    public void registerWorkflowDefinition() {
        for (WorkflowDefinition definition : this.workflowDefinitions) {
            try {
                this.processDefService.register(definition.defineProcess());
                log.info("success register workflow definition: {}", (Object)definition.getProcessName());
            }
            catch (Exception e) {
                log.error("failed to register workflow definition {}", (Object)definition.getProcessName(), (Object)e);
            }
        }
    }
}

