/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

public class AlgorithmOptions {
    public static final ConfigOption<Boolean> HASH_JOIN_BLOOM_FILTERS = ConfigOptions.key("taskmanager.runtime.hashjoin-bloom-filters").booleanType().defaultValue(false).withDescription("Flag to activate/deactivate bloom filters in the hybrid hash join implementation. In cases where the hash join needs to spill to disk (datasets larger than the reserved fraction of memory), these bloom filters can greatly reduce the number of spilled records, at the cost some CPU cycles.");
    public static final ConfigOption<Integer> SPILLING_MAX_FAN = ConfigOptions.key("taskmanager.runtime.max-fan").intType().defaultValue(128).withDescription("The maximal fan-in for external merge joins and fan-out for spilling hash tables. Limits the number of file handles per operator, but may cause intermediate merging/partitioning, if set too small.");
    public static final ConfigOption<Float> SORT_SPILLING_THRESHOLD = ConfigOptions.key("taskmanager.runtime.sort-spilling-threshold").floatType().defaultValue(Float.valueOf(0.8f)).withDescription("A sort operation starts spilling when this fraction of its memory budget is full.");
    public static final ConfigOption<Boolean> USE_LARGE_RECORDS_HANDLER = ConfigOptions.key("taskmanager.runtime.large-record-handler").booleanType().defaultValue(false).withDescription("Whether to use the LargeRecordHandler when spilling. If a record will not fit into the sorting buffer. The record will be spilled on disk and the sorting will continue with only the key. The record itself will be read afterwards when merging.");
}

