/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.sink.writer;

import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@Internal
public final class AIMDRateLimitingStrategy {
    private final int increaseRate;
    private final double decreaseFactor;
    private final int rateThreshold;
    private int inFlightMessages;

    public AIMDRateLimitingStrategy(int increaseRate, double decreaseFactor, int rateThreshold, int initialRate) {
        Preconditions.checkArgument((decreaseFactor < 1.0 && decreaseFactor > 0.0 ? 1 : 0) != 0, (Object)"Decrease factor must be between 0.0 and 1.0.");
        Preconditions.checkArgument((increaseRate > 0 ? 1 : 0) != 0, (Object)"Increase rate must be positive integer.");
        Preconditions.checkArgument((rateThreshold >= initialRate ? 1 : 0) != 0, (Object)"Initial rate must not exceed threshold.");
        this.increaseRate = increaseRate;
        this.decreaseFactor = decreaseFactor;
        this.rateThreshold = rateThreshold;
        this.inFlightMessages = initialRate;
    }

    public int getRateLimit() {
        return this.inFlightMessages;
    }

    public void scaleUp() {
        this.inFlightMessages = Math.min(this.inFlightMessages + this.increaseRate, this.rateThreshold);
    }

    public void scaleDown() {
        this.inFlightMessages = Math.max(1, (int)Math.round((double)this.inFlightMessages * this.decreaseFactor));
    }
}

