/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process;

import com.google.common.collect.ImmutableMap;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.decode.SourceDecoder;
import org.apache.inlong.sdk.transform.encode.DefaultSinkData;
import org.apache.inlong.sdk.transform.encode.SinkEncoder;
import org.apache.inlong.sdk.transform.pojo.FieldInfo;
import org.apache.inlong.sdk.transform.pojo.TransformConfig;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.ValueParserNode;
import org.apache.inlong.sdk.transform.process.operator.ExpressionOperator;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ColumnParser;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

public class TransformProcessor<I, O> {
    private static final Map<String, Object> EMPTY_EXT_PARAMS = ImmutableMap.of();
    private static final String DUMMY_SELECT = "select *";
    private final TransformConfig config;
    private final SourceDecoder<I> decoder;
    private final SinkEncoder<O> encoder;
    private PlainSelect transformSelect;
    private ExpressionOperator where;
    private List<ValueParserNode> selectItems;
    private List<String> sinkFieldList;

    public static <I, O> TransformProcessor<I, O> create(TransformConfig config, SourceDecoder<I> decoder, SinkEncoder<O> encoder) throws JSQLParserException {
        return new TransformProcessor<I, O>(config, decoder, encoder);
    }

    private TransformProcessor(TransformConfig config, SourceDecoder<I> decoder, SinkEncoder<O> encoder) throws JSQLParserException {
        this.config = config;
        this.decoder = decoder;
        this.encoder = encoder;
        this.init();
    }

    private void init() throws JSQLParserException {
        if (!this.config.isStrictOrder() && this.encoder != null && this.encoder.getFields() != null) {
            List<FieldInfo> fields = this.encoder.getFields();
            this.sinkFieldList = new ArrayList<String>(fields.size());
            fields.forEach(v -> this.sinkFieldList.add(v.getName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.config.getTransformSql())) {
            this.initTransformSql(this.config.getTransformSql());
        } else {
            this.initTransformSql(DUMMY_SELECT);
        }
    }

    private void initTransformSql(String sql) throws JSQLParserException {
        CCJSqlParserManager parserManager = new CCJSqlParserManager();
        Select select = (Select)parserManager.parse((Reader)new StringReader(sql));
        this.transformSelect = (PlainSelect)select.getSelectBody();
        this.where = OperatorTools.buildOperator(this.transformSelect.getWhere());
        List items = this.transformSelect.getSelectItems();
        this.selectItems = new ArrayList<ValueParserNode>(items.size());
        List<FieldInfo> fields = this.encoder.getFields();
        for (int i = 0; i < items.size(); ++i) {
            SelectItem item = (SelectItem)items.get(i);
            String fieldName = null;
            if (this.config.isStrictOrder() && i < fields.size()) {
                fieldName = fields.get(i).getName();
            }
            if (item instanceof SelectExpressionItem) {
                SelectExpressionItem exprItem = (SelectExpressionItem)item;
                if (fieldName == null && !this.checkSelectField(fieldName = exprItem.getAlias() == null ? exprItem.toString() : exprItem.getAlias().getName())) {
                    throw new JSQLParserException(String.format("Field name:%s can not be found in sink field list.", fieldName));
                }
                this.selectItems.add(new ValueParserNode(fieldName, OperatorTools.buildParser(exprItem.getExpression())));
                continue;
            }
            if (!(item instanceof AllColumns)) continue;
            for (FieldInfo fieldInfo : this.decoder.getFields()) {
                String name = fieldInfo.getName();
                this.selectItems.add(new ValueParserNode(name, new ColumnParser(new Column(name))));
            }
        }
    }

    public boolean checkSelectField(String fieldName) {
        if (this.config.isIgnoreConfigError()) {
            return true;
        }
        return this.sinkFieldList != null && this.sinkFieldList.contains(fieldName);
    }

    public List<O> transform(I input) {
        return this.transform(input, EMPTY_EXT_PARAMS);
    }

    public List<O> transform(I input, Map<String, Object> extParams) {
        Context context = new Context(this.config.getConfiguration(), extParams);
        SourceData sourceData = this.decoder.decode(input, context);
        if (sourceData == null) {
            return null;
        }
        ArrayList<O> sinkDatas = new ArrayList<O>(sourceData.getRowCount());
        for (int i = 0; i < sourceData.getRowCount(); ++i) {
            if (this.where != null && !this.where.check(sourceData, i, context)) continue;
            DefaultSinkData sinkData = new DefaultSinkData();
            for (ValueParserNode node : this.selectItems) {
                String fieldName = node.getFieldName();
                ValueParser parser = node.getParser();
                if (parser == null || StringUtils.equals((CharSequence)fieldName, (CharSequence)"*")) {
                    if (input instanceof String) {
                        sinkData.addField(fieldName, (String)input);
                        continue;
                    }
                    sinkData.addField(fieldName, "");
                    continue;
                }
                try {
                    Object fieldValue = parser.parse(sourceData, i, context);
                    if (fieldValue == null) {
                        sinkData.addField(fieldName, "");
                        continue;
                    }
                    sinkData.addField(fieldName, fieldValue.toString());
                    context.put(fieldName, fieldValue);
                }
                catch (Throwable t) {
                    sinkData.addField(fieldName, "");
                }
            }
            if (this.sinkFieldList != null) {
                sinkData.setKeyList(this.sinkFieldList);
            }
            sinkDatas.add(this.encoder.encode(sinkData, context));
        }
        return sinkDatas;
    }

    public List<O> transformForBytes(byte[] input, Map<String, Object> extParams) {
        Context context = new Context(this.config.getConfiguration(), extParams);
        SourceData sourceData = this.decoder.decode(input, context);
        if (sourceData == null) {
            return null;
        }
        ArrayList<O> sinkDatas = new ArrayList<O>(sourceData.getRowCount());
        for (int i = 0; i < sourceData.getRowCount(); ++i) {
            if (this.where != null && !this.where.check(sourceData, i, context)) continue;
            DefaultSinkData sinkData = new DefaultSinkData();
            for (ValueParserNode node : this.selectItems) {
                String fieldName = node.getFieldName();
                ValueParser parser = node.getParser();
                if (parser == null || StringUtils.equals((CharSequence)fieldName, (CharSequence)"*")) {
                    sinkData.addField(fieldName, "");
                    continue;
                }
                try {
                    Object fieldValue = parser.parse(sourceData, i, context);
                    if (fieldValue == null) {
                        sinkData.addField(fieldName, "");
                        continue;
                    }
                    sinkData.addField(fieldName, fieldValue.toString());
                }
                catch (Throwable t) {
                    sinkData.addField(fieldName, "");
                }
            }
            if (this.sinkFieldList != null) {
                sinkData.setKeyList(this.sinkFieldList);
            }
            sinkDatas.add(this.encoder.encode(sinkData, context));
        }
        return sinkDatas;
    }
}

