/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformFunction(type="arithmetic", names={"greatest"}, parameter="(Numeric value1 [,Numeric value2,...])", descriptions={"- Return \"\" if any parameter is NULL;", "- Return the greatest value of the list of arguments."}, examples={"greatest(3.141592653589793, 3, greatest(4, 1)) = 4"})
public class GreatestFunction
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(GreatestFunction.class);
    private List<ValueParser> parserList;

    public GreatestFunction(Function expr) {
        if (expr.getParameters() == null) {
            this.parserList = new ArrayList<ValueParser>();
        } else {
            List params = expr.getParameters().getExpressions();
            this.parserList = new ArrayList<ValueParser>(params.size());
            for (Expression param : params) {
                ValueParser node = OperatorTools.buildParser(param);
                this.parserList.add(node);
            }
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        BigDecimal maxValue = null;
        for (ValueParser valueParser : this.parserList) {
            Object valueObj = valueParser.parse(sourceData, rowIndex, context);
            if (valueObj == null) {
                return null;
            }
            BigDecimal value = OperatorTools.parseBigDecimal(valueObj);
            if (maxValue != null && value.compareTo(maxValue) <= 0) continue;
            maxValue = value;
        }
        return maxValue;
    }
}

