/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.util.List;
import java.util.Random;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"rand_integer"}, parameter="(Integer INT1, [Integer INT2])", descriptions={"- Return a pseudorandom integer value in the range [0, 'INT1') if 'INT2' is NULL;", "- Return a pseudorandom integer value in the range [0, 'INT1') with an initial seed 'INT2'.", "Note: Two RAND_INTEGER functions will return idential sequences of numbers if they have the same initial seed and bound."}, examples={"rand_integer(10)", "rand_integer(88, 89)"})
public class RandIntegerFunction
implements ValueParser {
    private ValueParser firstIntParser;
    private ValueParser secondIntParser;
    private Random random = new Random();

    public RandIntegerFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        if (expressions != null) {
            this.firstIntParser = OperatorTools.buildParser((Expression)expressions.get(0));
            if (expressions.size() >= 2) {
                this.secondIntParser = OperatorTools.buildParser((Expression)expressions.get(1));
            }
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object firstIntObj = this.firstIntParser.parse(sourceData, rowIndex, context);
        int firstInt = OperatorTools.parseBigDecimal(firstIntObj).intValue();
        if (this.secondIntParser != null) {
            Object secondIntObj = this.secondIntParser.parse(sourceData, rowIndex, context);
            int secondInt = OperatorTools.parseBigDecimal(secondIntObj).intValue();
            return this.randInteger(firstInt, secondInt);
        }
        return this.randInteger(firstInt);
    }

    private int randInteger(int range) {
        return this.random.nextInt(range);
    }

    private int randInteger(int range, int seed) {
        this.random.setSeed(seed);
        return this.random.nextInt(range);
    }
}

