/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"truncate", "trunc"}, parameter="(Numeric numeric, Integer cnt)", descriptions={"- Return \"\" if any parameter is NULL;", "- Return the result of truncating 'numeric' values to 'cnt' decimal places."}, examples={"truncate(42.324, 2) = 42.32", "trunc(42.324, -1) = 40"})
public class TruncateFunction
implements ValueParser {
    private ValueParser bigDecimalParser;
    private ValueParser integerParser;

    public TruncateFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        if (expressions != null) {
            this.bigDecimalParser = OperatorTools.buildParser((Expression)expressions.get(0));
            if (expressions.size() >= 2) {
                this.integerParser = OperatorTools.buildParser((Expression)expressions.get(1));
            }
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object bigDecimalObj = this.bigDecimalParser.parse(sourceData, rowIndex, context);
        BigDecimal bigDecimal = OperatorTools.parseBigDecimal(bigDecimalObj);
        if (this.integerParser != null) {
            Object integerObj = this.integerParser.parse(sourceData, rowIndex, context);
            int integer = OperatorTools.parseBigDecimal(integerObj).intValue();
            return this.truncate(bigDecimal, integer);
        }
        return this.truncate(bigDecimal);
    }

    private BigDecimal truncate(BigDecimal numeric1, Integer integer2) {
        if (numeric1 == null || integer2 == null) {
            return null;
        }
        if (integer2 < 0) {
            BigDecimal scaled = numeric1.movePointLeft(-integer2.intValue());
            BigDecimal truncated = scaled.setScale(0, RoundingMode.DOWN);
            return truncated.movePointRight(-integer2.intValue());
        }
        return numeric1.setScale((int)integer2, RoundingMode.DOWN);
    }

    private BigDecimal truncate(BigDecimal numeric1) {
        if (numeric1 == null) {
            return null;
        }
        return numeric1.setScale(0, RoundingMode.DOWN);
    }
}

