/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.ArrayList;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformFunction(type="collection", names={"element"}, parameter="(Array array)", descriptions={"- Return \"\" if 'array' is empty or NULL;", "- Return the sole element of 'array' (whose cardinality should be one).", "Note: Throws an exception if array has more than one element."}, examples={"element(array('he')) = he"})
public class ElementFunction
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(ElementFunction.class);
    private final ValueParser valueParser;

    public ElementFunction(Function expr) {
        this.valueParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object valueObj = this.valueParser.parse(sourceData, rowIndex, context);
        if (valueObj instanceof ArrayList) {
            ArrayList array = (ArrayList)valueObj;
            if (array.isEmpty()) {
                return null;
            }
            if (array.size() == 1) {
                return array.get(0);
            }
            log.warn("Array contains more than one element", (Throwable)new IllegalArgumentException());
            return null;
        }
        return null;
    }
}

