/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.compression;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.function.compression.factory.UnCompressionAlgorithmFactory;
import org.apache.inlong.sdk.transform.process.function.compression.handler.UncompressHandler;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformFunction(type="compression", names={"uncompress"}, parameter="(String string_to_uncompress, String compress_type)", descriptions={"- Return \"\" if 'string_to_uncompress' is NULL;", "- Return \"\" if 'string_to_uncompress' is \"\";", "- Return the result as a string.", "Note: This function supports three compression algorithms: deflater, gzip and zip. 'compress_type' defaults to defer."}, examples={"uncompress(compress('inlong')) = \"inlong\""})
public class UnCompressFunction
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(UnCompressFunction.class);
    private final ValueParser stringParser;
    private final ValueParser uncompressTypeParser;
    private final Charset CHARSET = StandardCharsets.ISO_8859_1;
    private final String DEFAULT_UNCOMPRESS_TYPE = "deflater";

    public UnCompressFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.stringParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.uncompressTypeParser = expressions.size() == 2 ? OperatorTools.buildParser((Expression)expressions.get(1)) : null;
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object compressTypeObj;
        Object stringObject = this.stringParser.parse(sourceData, rowIndex, context);
        if (stringObject == null) {
            return null;
        }
        String str = OperatorTools.parseString(stringObject);
        if (str.isEmpty()) {
            return "";
        }
        if (str.startsWith("null")) {
            return null;
        }
        String uncompressType = "deflater";
        if (this.uncompressTypeParser != null && (compressTypeObj = this.uncompressTypeParser.parse(sourceData, rowIndex, context)) != null) {
            uncompressType = OperatorTools.parseString(compressTypeObj);
        }
        uncompressType = uncompressType.toLowerCase();
        try {
            byte[] compressData = Arrays.copyOfRange(str.getBytes(this.CHARSET), 4, str.length());
            UncompressHandler handler = UnCompressionAlgorithmFactory.getCompressHandlerByName(uncompressType);
            if (handler == null) {
                throw new RuntimeException(uncompressType + " is not supported.");
            }
            return new String(handler.uncompress(compressData));
        }
        catch (Exception e) {
            log.error("UnCompression failed", (Throwable)e);
            return null;
        }
    }
}

