/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.json;

import com.alibaba.fastjson.JSONPath;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="json", names={"json_query"}, parameter="(String json_doc, String path)", descriptions={"- Return \"\" if any parameter is NULL;", "- Return the string parsed from the 'path' in 'json_doc'."}, examples={"json_query({\\\"people\\\": [{\\\"name\\\": \\\"Alice\\\"}, {\\\"name\\\": \\\"Bob\\\"}]}, $.people) = [{\"name\":\"Alice\"},{\"name\":\"Bob\"}]", "json_query({\\\"list\\\": [null, {\\\"name\\\": \\\"John\\\"}]}, $.list[1].name) = John"})
public class JsonQueryFunction
implements ValueParser {
    private final ValueParser jsonParser;
    private final ValueParser pathParser;

    public JsonQueryFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.jsonParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.pathParser = OperatorTools.buildParser((Expression)expressions.get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object jsonObj = this.jsonParser.parse(sourceData, rowIndex, context);
        Object pathObj = this.pathParser.parse(sourceData, rowIndex, context);
        if (jsonObj == null || pathObj == null) {
            return null;
        }
        String path = OperatorTools.parseString(pathObj);
        String json = OperatorTools.parseString(jsonObj);
        if (path.isEmpty()) {
            return null;
        }
        Object res = JSONPath.read((String)json, (String)path);
        return res != null ? res.toString() : null;
    }
}

