/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"regexp_extract_all"}, parameter="(String str, String regexp, [Integer extractIndex])", descriptions={"- Return \"\" if any of the arguments are NULL or invalid;", "- Return an array consisting of all substrings from the 'str' that match the 'regexp' expression and correspond to the 'extractIndex' set of regular expressions.", "Note: 'regexp' must be a Java regular expression. 'extractIndex' indicates which regexp group to extract and starts from 1, also the default value if not specified. 0 means matching the entire 'regexp' expression."}, examples={"REGEXP_EXTRACT_ALL(\"abc123def456ghi789\", \"(\\\\d+)\", 0) = [123, 456, 789]", "REGEXP_EXTRACT_ALL(\"Name: John, Age: 25, Location: NY\", \"Name: (\\\\w+), Age: (\\\\d+), Location: (\\\\w+)\", 1) = [John]", "REGEXP_EXTRACT_ALL(\"Name: John, Age: 25, Location: NY\", \"Name: (\\\\w+), Age: (\\\\d+), Location: (\\\\w+)\", 0) = [Name: John, Age: 25, Location: NY]"})
public class RegexpExtractAllFunction
implements ValueParser {
    private ValueParser inputStringParser;
    private ValueParser patternStringParser;
    private ValueParser indexIntegerParser;

    public RegexpExtractAllFunction(Function expr) {
        List expressions;
        if (expr.getParameters() != null && (expressions = expr.getParameters().getExpressions()) != null && expressions.size() >= 2) {
            this.inputStringParser = OperatorTools.buildParser((Expression)expressions.get(0));
            this.patternStringParser = OperatorTools.buildParser((Expression)expressions.get(1));
            if (expressions.size() >= 3) {
                this.indexIntegerParser = OperatorTools.buildParser((Expression)expressions.get(2));
            }
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        if (this.inputStringParser == null || this.patternStringParser == null) {
            return null;
        }
        String inputString = OperatorTools.parseString(this.inputStringParser.parse(sourceData, rowIndex, context));
        String patternString = OperatorTools.parseString(this.patternStringParser.parse(sourceData, rowIndex, context));
        int index = 0;
        if (this.indexIntegerParser != null) {
            index = OperatorTools.parseBigDecimal(this.indexIntegerParser.parse(sourceData, rowIndex, context)).intValue();
        }
        if (index < 0) {
            return null;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(inputString);
        while (matcher.find()) {
            if (index <= matcher.groupCount()) {
                resultList.add(matcher.group(index));
                continue;
            }
            return null;
        }
        return resultList.isEmpty() ? null : resultList;
    }
}

