/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import com.google.gson.JsonObject;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"str_to_json"}, parameter="(String s1, String pairDelimiter, String keyValueDelimiter)", descriptions={"- Return \"\" if 'str' is NULL;", "- Return a json string after splitting the 'str' into key/value pairs using 'pairDelimiter'(default is ',') and 'keyValueDelimiter'(default is '=');", "Note: Both 'pairDelimiter' and 'keyValueDelimiter' are treated as regular expressions.So special characters(e.g. <([{^-=$!|]})?*+.>) need to be properly escaped before using as a delimiter literally."}, examples={"str_to_json('key1=value1,key2=value2,key3=value3') = {\"key1\":\"value1\",\"key2\":\"value2\",\"key3\"=\"value3\"}", "str_to_json(\"name->John!age->30!city->China\" , \"!\" , \"->\") = {\"name\":\"John\",\"age\":\"30\",\"city\":\"China\"}"})
public class StrToJsonFunction
implements ValueParser {
    private ValueParser inputParser;
    private ValueParser pairDelimiterParser;
    private ValueParser kvDelimiterParser;

    public StrToJsonFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        if (!expressions.isEmpty()) {
            this.inputParser = OperatorTools.buildParser((Expression)expressions.get(0));
            if (expressions.size() >= 2) {
                this.pairDelimiterParser = OperatorTools.buildParser((Expression)expressions.get(1));
                if (expressions.size() >= 3) {
                    this.kvDelimiterParser = OperatorTools.buildParser((Expression)expressions.get(2));
                }
            }
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object inputStringObj = this.inputParser.parse(sourceData, rowIndex, context);
        Object pairDelimiterStringObj = null;
        String pairDelimiterString = null;
        if (this.pairDelimiterParser != null) {
            pairDelimiterStringObj = this.pairDelimiterParser.parse(sourceData, rowIndex, context);
            pairDelimiterString = OperatorTools.parseString(pairDelimiterStringObj);
        }
        Object kvDelimiterStringObj = null;
        String kvDelimiterString = null;
        if (this.kvDelimiterParser != null) {
            kvDelimiterStringObj = this.kvDelimiterParser.parse(sourceData, rowIndex, context);
            kvDelimiterString = OperatorTools.parseString(kvDelimiterStringObj);
        }
        String inputString = OperatorTools.parseString(inputStringObj);
        return this.parse2Json(pairDelimiterString, kvDelimiterString, inputString);
    }

    private JsonObject parse2Json(String pairDelimiterString, String kvDelimiterString, String inputString) {
        String[] pairs;
        String pairDelimiter = pairDelimiterString == null || pairDelimiterString.isEmpty() ? "," : this.escapeRegex(pairDelimiterString);
        String keyValueDelimiter = kvDelimiterString == null || kvDelimiterString.isEmpty() ? "=" : this.escapeRegex(kvDelimiterString);
        JsonObject json = new JsonObject();
        for (String pair : pairs = inputString.split(pairDelimiter)) {
            if (!pair.contains(keyValueDelimiter)) continue;
            String[] keyValue = pair.split(keyValueDelimiter, 2);
            json.addProperty(keyValue[0], keyValue[1]);
        }
        return json;
    }

    private String escapeRegex(String delimiter) {
        return delimiter.replaceAll("([\\\\^$|?*+\\[\\](){}])", "\\\\$1");
    }
}

