/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"url_encode"}, parameter="(String str[, String charset])", descriptions={"- Return \"\" if 'str' is NULL, or there is an issue with the decoding process(such as encountering an illegal escape pattern), or the encoding scheme is not supported;", "- Return the result of translating 'str' into 'application/x-www-form-urlencoded' format using the charset(default:UTF-8) encoding scheme."}, examples={"url_encode('https://apache.inlong.com/search?q=java url encode') = \"https%3A%2F%2Fapache.inlong.com%2Fsearch%3Fq%3Djava+url+encode\"", "url_encode('https://apache.inlong.com/search?q=java url encode','UTF-8') = \"https%3A%2F%2Fapache.inlong.com%2Fsearch%3Fq%3Djava+url+encode\""})
public class UrlEncodeFunction
implements ValueParser {
    private final ValueParser stringParser;
    private final ValueParser charsetParser;

    public UrlEncodeFunction(Function expr) {
        List params = expr.getParameters().getExpressions();
        this.stringParser = OperatorTools.buildParser((Expression)params.get(0));
        this.charsetParser = params.size() > 1 ? OperatorTools.buildParser((Expression)params.get(1)) : null;
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObj = this.stringParser.parse(sourceData, rowIndex, context);
        if (stringObj == null) {
            return null;
        }
        String string = OperatorTools.parseString(stringObj);
        if (string == null) {
            return null;
        }
        try {
            if (this.charsetParser == null) {
                return URLEncoder.encode(string, StandardCharsets.UTF_8.toString());
            }
            Object charsetObj = this.charsetParser.parse(sourceData, rowIndex, context);
            if (charsetObj == null) {
                return null;
            }
            String charset = OperatorTools.parseString(charsetObj);
            if (charset == null) {
                return null;
            }
            return URLEncoder.encode(string, charset);
        }
        catch (Exception e) {
            return null;
        }
    }
}

