/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.temporal;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.apache.inlong.sdk.transform.process.utils.DateUtil;

@TransformFunction(type="temporal", names={"datediff"}, parameter="(String dateStr1, String dateStr2)", descriptions={"- Return \"\" if one of the two parameters is null or \"\";", "- Return \"\" if one of the two parameters has an incorrect date format;", "- Return the number of days between the dates 'dateStr1'->'dateStr2'."}, examples={"datediff('2018-12-10 12:30:00', '2018-12-09 13:30:00') = 1", "datediff('2018-12', '2018-12-12') = \"\""})
public class DateDiffFunction
implements ValueParser {
    private final ValueParser leftDateParser;
    private final ValueParser rightDateParser;

    public DateDiffFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.leftDateParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.rightDateParser = OperatorTools.buildParser((Expression)expressions.get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object leftDateObj = this.leftDateParser.parse(sourceData, rowIndex, context);
        Object rightDateObj = this.rightDateParser.parse(sourceData, rowIndex, context);
        if (leftDateObj == null || rightDateObj == null) {
            return null;
        }
        String leftDate = OperatorTools.parseString(leftDateObj);
        String rightDate = OperatorTools.parseString(rightDateObj);
        if (leftDate.isEmpty() || rightDate.isEmpty()) {
            return null;
        }
        try {
            LocalDate left = Objects.requireNonNull(DateUtil.parseLocalDateTime(leftDate)).toLocalDate();
            LocalDate right = Objects.requireNonNull(DateUtil.parseLocalDateTime(rightDate)).toLocalDate();
            return ChronoUnit.DAYS.between(right, left);
        }
        catch (Exception e) {
            return null;
        }
    }
}

