/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.operator;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.operator.ExpressionOperator;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.operator.TransformOperator;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformOperator(values={InExpression.class})
public class InOperator
implements ExpressionOperator {
    private final ValueParser left;
    private final List<ValueParser> right;

    public InOperator(InExpression expr) {
        this.left = OperatorTools.buildParser(expr.getLeftExpression());
        ItemsList itemsList = expr.getRightItemsList();
        this.right = new ArrayList<ValueParser>();
        if (itemsList instanceof ExpressionList) {
            ((ExpressionList)itemsList).getExpressions().forEach(v -> this.right.add(OperatorTools.buildParser(v)));
        } else if (itemsList instanceof MultiExpressionList) {
            List exprListList = ((MultiExpressionList)itemsList).getExpressionLists();
            for (ExpressionList exprList : exprListList) {
                exprList.getExpressions().forEach(v -> this.right.add(OperatorTools.buildParser(v)));
            }
        } else if (itemsList instanceof NamedExpressionList) {
            ((NamedExpressionList)itemsList).getExpressions().forEach(v -> this.right.add(OperatorTools.buildParser(v)));
        }
    }

    @Override
    public boolean check(SourceData sourceData, int rowIndex, Context context) {
        Comparable leftValue = (Comparable)this.left.parse(sourceData, rowIndex, context);
        for (ValueParser parser : this.right) {
            Comparable rightValue = (Comparable)parser.parse(sourceData, rowIndex, context);
            if (OperatorTools.compareValue(leftValue, rightValue) != 0) continue;
            return true;
        }
        return false;
    }
}

