/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Base64;

class TransformUtil {
    private static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    private static final int EPOCH_YEAR = EPOCH.getYear();

    private TransformUtil() {
    }

    static String humanYear(int yearOrdinal) {
        return String.format("%04d", EPOCH_YEAR + yearOrdinal);
    }

    static String humanMonth(int monthOrdinal) {
        return String.format("%04d-%02d", EPOCH_YEAR + Math.floorDiv(monthOrdinal, 12), 1 + Math.floorMod(monthOrdinal, 12));
    }

    static String humanDay(int dayOrdinal) {
        OffsetDateTime day = EPOCH.plusDays(dayOrdinal);
        return String.format("%04d-%02d-%02d", day.getYear(), day.getMonth().getValue(), day.getDayOfMonth());
    }

    static String humanTime(Long microsFromMidnight) {
        return LocalTime.ofNanoOfDay(microsFromMidnight * 1000L).toString();
    }

    static String humanTimestampWithZone(Long timestampMicros) {
        return ChronoUnit.MICROS.addTo(EPOCH, timestampMicros).toString();
    }

    static String humanTimestampWithoutZone(Long timestampMicros) {
        return ChronoUnit.MICROS.addTo(EPOCH, timestampMicros).toLocalDateTime().toString();
    }

    static String humanHour(int hourOrdinal) {
        OffsetDateTime time = EPOCH.plusHours(hourOrdinal);
        return String.format("%04d-%02d-%02d-%02d", time.getYear(), time.getMonth().getValue(), time.getDayOfMonth(), time.getHour());
    }

    static String base64encode(ByteBuffer buffer) {
        return StandardCharsets.ISO_8859_1.decode(Base64.getEncoder().encode(buffer)).toString();
    }
}

