/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util;

import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;

public final class SelectUtils {
    private static final String NOT_SUPPORTED_YET = "Not supported yet.";

    private SelectUtils() {
    }

    public static Select buildSelectFromTableAndExpressions(Table table, Expression ... expr) {
        SelectItem[] list = new SelectItem[expr.length];
        for (int i = 0; i < expr.length; ++i) {
            list[i] = new SelectExpressionItem(expr[i]);
        }
        return SelectUtils.buildSelectFromTableAndSelectItems(table, list);
    }

    public static Select buildSelectFromTableAndExpressions(Table table, String ... expr) throws JSQLParserException {
        SelectItem[] list = new SelectItem[expr.length];
        for (int i = 0; i < expr.length; ++i) {
            list[i] = new SelectExpressionItem(CCJSqlParserUtil.parseExpression(expr[i]));
        }
        return SelectUtils.buildSelectFromTableAndSelectItems(table, list);
    }

    public static Select buildSelectFromTableAndSelectItems(Table table, SelectItem ... selectItems) {
        PlainSelect body = new PlainSelect().addSelectItems(selectItems).withFromItem(table);
        return new Select().withSelectBody(body);
    }

    public static Select buildSelectFromTable(Table table) {
        return SelectUtils.buildSelectFromTableAndSelectItems(table, new AllColumns());
    }

    public static void addExpression(Select select, Expression expr) {
        if (!(select.getSelectBody() instanceof PlainSelect)) {
            throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
        }
        select.getSelectBody(PlainSelect.class).getSelectItems().add(new SelectExpressionItem(expr));
    }

    public static Join addJoin(Select select, Table table, Expression onExpression) {
        if (select.getSelectBody() instanceof PlainSelect) {
            Join join = new Join().withRightItem(table).addOnExpression(onExpression);
            select.getSelectBody(PlainSelect.class).addJoins(join);
            return join;
        }
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    public static void addGroupBy(Select select, Expression expr) {
        if (!(select.getSelectBody() instanceof PlainSelect)) {
            throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
        }
        select.getSelectBody(PlainSelect.class).addGroupByColumnReference(expr);
    }
}

