/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core;

import com.google.common.collect.Lists;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.core.AgentManager;
import org.apache.inlong.agent.core.task.MemoryManager;
import org.apache.inlong.agent.core.task.OffsetManager;
import org.apache.inlong.agent.core.task.TaskManager;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ExcuteLinux;
import org.apache.inlong.sdk.dataproxy.common.ProcessResult;
import org.apache.inlong.sdk.dataproxy.sender.tcp.TcpEventInfo;
import org.apache.inlong.sdk.dataproxy.sender.tcp.TcpMsgSender;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentStatusManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentStatusManager.class);
    public static final String INLONG_AGENT_SYSTEM = "inlong_agent_system";
    public static final String INLONG_AGENT_STATUS = "inlong_agent_status";
    private static AgentStatusManager manager = null;
    private final AgentConfiguration conf;
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Runtime runtime = Runtime.getRuntime();
    final long GB = 0x40000000L;
    private ThreadMXBean threadBean;
    private final long INVALID_CPU = -1L;
    private RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private AgentManager agentManager;
    public static AtomicLong sendDataLen = new AtomicLong();
    public static AtomicLong sendPackageCount = new AtomicLong();
    private String processStartupTime = this.format.format(this.runtimeMXBean.getStartTime());
    private String systemStartupTime = ExcuteLinux.exeCmd((String)"uptime -s").replaceAll("\r|\n", "");

    private AgentStatusManager(AgentManager agentManager) {
        this.conf = AgentConfiguration.getAgentConf();
        this.threadBean = ManagementFactory.getThreadMXBean();
        this.agentManager = agentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(AgentManager agentManager) {
        Class<AgentStatusManager> clazz = AgentStatusManager.class;
        synchronized (AgentStatusManager.class) {
            if (manager == null) {
                manager = new AgentStatusManager(agentManager);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static AgentStatusManager getInstance() {
        return manager;
    }

    private void doSendStatusMsg(TcpMsgSender sender) {
        AgentStatus data = AgentStatusManager.getInstance().getStatus();
        LOGGER.info("status detail: {}", (Object)data);
        if (sender == null) {
            return;
        }
        try {
            ProcessResult procResult = new ProcessResult();
            long dataTime = AgentUtils.getCurrentTime();
            byte[] body = data.getFieldsString().getBytes(StandardCharsets.UTF_8);
            if (!sender.sendMessage(new TcpEventInfo(INLONG_AGENT_SYSTEM, INLONG_AGENT_STATUS, dataTime, null, body), procResult)) {
                LOGGER.error("send status failed: ret = {}", (Object)procResult);
                AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_SEND_FAILED, (String)INLONG_AGENT_SYSTEM, (String)INLONG_AGENT_STATUS, (long)dataTime, (int)1, (long)body.length);
                AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_SEND_FAILED_REAL_TIME, (String)INLONG_AGENT_SYSTEM, (String)INLONG_AGENT_STATUS, (long)dataTime, (int)1, (long)body.length);
            } else {
                AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_SEND_SUCCESS, (String)INLONG_AGENT_SYSTEM, (String)INLONG_AGENT_STATUS, (long)dataTime, (int)1, (long)body.length);
                AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_SEND_SUCCESS_REAL_TIME, (String)INLONG_AGENT_SYSTEM, (String)INLONG_AGENT_STATUS, (long)dataTime, (int)1, (long)body.length);
            }
        }
        catch (Throwable ex) {
            LOGGER.error("send status throw exception", ex);
        }
    }

    public static void sendStatusMsg(TcpMsgSender sender) {
        if (AgentStatusManager.getInstance() != null) {
            AgentStatusManager.getInstance().doSendStatusMsg(sender);
        }
    }

    private double getProcessCpu() {
        double cpu = this.tryGetProcessCpu();
        for (int tryTimes = 0; cpu < 0.0 && tryTimes < 10; ++tryTimes) {
            cpu = this.tryGetProcessCpu();
        }
        return cpu;
    }

    private double tryGetProcessCpu() {
        long temp;
        long[] startThreads = this.threadBean.getAllThreadIds();
        long startTime = System.nanoTime();
        long startUseTime = 0L;
        for (long id : startThreads) {
            temp = this.threadBean.getThreadCpuTime(id);
            if (temp >= 0L) {
                startUseTime += temp;
                continue;
            }
            return -1.0;
        }
        AgentUtils.silenceSleepInMs((long)5000L);
        long[] endThreads = this.threadBean.getAllThreadIds();
        long endTime = System.nanoTime();
        long endUseTime = 0L;
        for (long id : endThreads) {
            temp = this.threadBean.getThreadCpuTime(id);
            if (temp >= 0L) {
                endUseTime += temp;
                continue;
            }
            return -1.0;
        }
        long usedTime = endUseTime - startUseTime;
        long totalPassedTime = endTime - startTime;
        return (double)usedTime / (double)totalPassedTime * 100.0;
    }

    private AgentStatus getStatus() {
        AgentStatus data = new AgentStatus();
        data.setAgentIp(this.conf.get("agent.local.ip"));
        data.setTag(this.conf.get("agent.cluster.tag"));
        data.setCluster(this.conf.get("agent.cluster.name"));
        data.setAgentVersion(TaskManager.class.getPackage().getImplementationVersion());
        data.setAgentStartTime(this.processStartupTime);
        data.setCpuCore(String.valueOf(this.runtime.availableProcessors()));
        data.setProcCpu(String.valueOf(this.twoDecimal(this.getProcessCpu())));
        data.setFreeMem(String.valueOf(this.twoDecimal((double)this.runtime.freeMemory() / 1.073741824E9)));
        data.setMaxMem(String.valueOf(this.twoDecimal((double)this.runtime.maxMemory() / 1.073741824E9)));
        data.setUseMem(String.valueOf(this.twoDecimal((double)this.runtime.totalMemory() / 1.073741824E9)));
        data.setOs(System.getProperty("os.version"));
        data.setInstallPlatform(this.conf.get("agent.install.platform", ""));
        data.setUsrDir(System.getProperty("user.dir"));
        data.setUsrName(System.getProperty("user.name"));
        data.setProcessId(String.valueOf(this.getProcessId()));
        if (AgentManager.getAgentConfigInfo() != null) {
            data.setGlobalConfigMd5(AgentManager.getAgentConfigInfo().getMd5());
        }
        data.setTaskMd5(this.agentManager.getTaskManager().getTaskResultMd5());
        this.agentManager.getTaskManager();
        data.setTaskNum(String.valueOf(TaskManager.getTaskStore().getTasks().size()));
        data.setInstanceNum(String.valueOf(OffsetManager.getInstance().getRunningInstanceCount()));
        data.setBootTime(this.systemStartupTime);
        data.setSendPackageCount(String.valueOf(sendPackageCount.getAndSet(0L)));
        data.setSendDataLen(String.valueOf(sendDataLen.getAndSet(0L)));
        data.setSourcePermitLeft(String.valueOf(MemoryManager.getInstance().getLeft("agent.global.reader.source.permit")));
        data.setQueuePermitLeft(String.valueOf(MemoryManager.getInstance().getLeft("agent.global.reader.queue.permit")));
        data.setWriterPermitLeft(String.valueOf(MemoryManager.getInstance().getLeft("agent.global.writer.permit")));
        data.setActiveThreadCount(String.valueOf(this.threadMXBean.getThreadCount()));
        return data;
    }

    public double twoDecimal(double doubleValue) {
        BigDecimal bigDecimal = new BigDecimal(doubleValue).setScale(2, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }

    private Long getProcessId() {
        try {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            String name = runtime.getName();
            String pid = name.substring(0, name.indexOf(64));
            return Long.parseLong(pid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class AgentStatus {
        private String agentIp;
        private String tag;
        private String cluster;
        private String agentVersion;
        private String agentStartTime;
        private String cpuCore;
        private String procCpu;
        private String freeMem;
        private String maxMem;
        private String useMem;
        private String os;
        private String installPlatform;
        private String usrDir;
        private String usrName;
        private String processId;
        private String globalConfigMd5;
        private String taskMd5;
        private String taskNum;
        private String instanceNum;
        private String bootTime;
        private String sendPackageCount;
        private String sendDataLen;
        private String sourcePermitLeft;
        private String queuePermitLeft;
        private String writerPermitLeft;
        private String activeThreadCount;

        public String getFieldsString() {
            ArrayList fields = Lists.newArrayList();
            fields.add(this.agentIp);
            fields.add(this.tag);
            fields.add(this.cluster);
            fields.add(this.agentVersion);
            fields.add(this.agentStartTime);
            fields.add(this.cpuCore);
            fields.add(this.procCpu);
            fields.add(this.freeMem);
            fields.add(this.maxMem);
            fields.add(this.useMem);
            fields.add(this.os);
            fields.add(this.installPlatform);
            fields.add(this.usrDir);
            fields.add(this.usrName);
            fields.add(this.processId);
            fields.add(this.globalConfigMd5);
            fields.add(this.taskMd5);
            fields.add(this.taskNum);
            fields.add(this.instanceNum);
            fields.add(this.bootTime);
            fields.add(this.sendPackageCount);
            fields.add(this.sendDataLen);
            fields.add(this.sourcePermitLeft);
            fields.add(this.queuePermitLeft);
            fields.add(this.writerPermitLeft);
            fields.add(this.activeThreadCount);
            return Strings.join((Iterable)fields, (char)',');
        }

        public String getAgentIp() {
            return this.agentIp;
        }

        public String getTag() {
            return this.tag;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getAgentVersion() {
            return this.agentVersion;
        }

        public String getAgentStartTime() {
            return this.agentStartTime;
        }

        public String getCpuCore() {
            return this.cpuCore;
        }

        public String getProcCpu() {
            return this.procCpu;
        }

        public String getFreeMem() {
            return this.freeMem;
        }

        public String getMaxMem() {
            return this.maxMem;
        }

        public String getUseMem() {
            return this.useMem;
        }

        public String getOs() {
            return this.os;
        }

        public String getInstallPlatform() {
            return this.installPlatform;
        }

        public String getUsrDir() {
            return this.usrDir;
        }

        public String getUsrName() {
            return this.usrName;
        }

        public String getProcessId() {
            return this.processId;
        }

        public String getGlobalConfigMd5() {
            return this.globalConfigMd5;
        }

        public String getTaskMd5() {
            return this.taskMd5;
        }

        public String getTaskNum() {
            return this.taskNum;
        }

        public String getInstanceNum() {
            return this.instanceNum;
        }

        public String getBootTime() {
            return this.bootTime;
        }

        public String getSendPackageCount() {
            return this.sendPackageCount;
        }

        public String getSendDataLen() {
            return this.sendDataLen;
        }

        public String getSourcePermitLeft() {
            return this.sourcePermitLeft;
        }

        public String getQueuePermitLeft() {
            return this.queuePermitLeft;
        }

        public String getWriterPermitLeft() {
            return this.writerPermitLeft;
        }

        public String getActiveThreadCount() {
            return this.activeThreadCount;
        }

        public void setAgentIp(String agentIp) {
            this.agentIp = agentIp;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        public void setAgentStartTime(String agentStartTime) {
            this.agentStartTime = agentStartTime;
        }

        public void setCpuCore(String cpuCore) {
            this.cpuCore = cpuCore;
        }

        public void setProcCpu(String procCpu) {
            this.procCpu = procCpu;
        }

        public void setFreeMem(String freeMem) {
            this.freeMem = freeMem;
        }

        public void setMaxMem(String maxMem) {
            this.maxMem = maxMem;
        }

        public void setUseMem(String useMem) {
            this.useMem = useMem;
        }

        public void setOs(String os) {
            this.os = os;
        }

        public void setInstallPlatform(String installPlatform) {
            this.installPlatform = installPlatform;
        }

        public void setUsrDir(String usrDir) {
            this.usrDir = usrDir;
        }

        public void setUsrName(String usrName) {
            this.usrName = usrName;
        }

        public void setProcessId(String processId) {
            this.processId = processId;
        }

        public void setGlobalConfigMd5(String globalConfigMd5) {
            this.globalConfigMd5 = globalConfigMd5;
        }

        public void setTaskMd5(String taskMd5) {
            this.taskMd5 = taskMd5;
        }

        public void setTaskNum(String taskNum) {
            this.taskNum = taskNum;
        }

        public void setInstanceNum(String instanceNum) {
            this.instanceNum = instanceNum;
        }

        public void setBootTime(String bootTime) {
            this.bootTime = bootTime;
        }

        public void setSendPackageCount(String sendPackageCount) {
            this.sendPackageCount = sendPackageCount;
        }

        public void setSendDataLen(String sendDataLen) {
            this.sendDataLen = sendDataLen;
        }

        public void setSourcePermitLeft(String sourcePermitLeft) {
            this.sourcePermitLeft = sourcePermitLeft;
        }

        public void setQueuePermitLeft(String queuePermitLeft) {
            this.queuePermitLeft = queuePermitLeft;
        }

        public void setWriterPermitLeft(String writerPermitLeft) {
            this.writerPermitLeft = writerPermitLeft;
        }

        public void setActiveThreadCount(String activeThreadCount) {
            this.activeThreadCount = activeThreadCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AgentStatus)) {
                return false;
            }
            AgentStatus other = (AgentStatus)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$agentIp = this.getAgentIp();
            String other$agentIp = other.getAgentIp();
            if (this$agentIp == null ? other$agentIp != null : !this$agentIp.equals(other$agentIp)) {
                return false;
            }
            String this$tag = this.getTag();
            String other$tag = other.getTag();
            if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
                return false;
            }
            String this$cluster = this.getCluster();
            String other$cluster = other.getCluster();
            if (this$cluster == null ? other$cluster != null : !this$cluster.equals(other$cluster)) {
                return false;
            }
            String this$agentVersion = this.getAgentVersion();
            String other$agentVersion = other.getAgentVersion();
            if (this$agentVersion == null ? other$agentVersion != null : !this$agentVersion.equals(other$agentVersion)) {
                return false;
            }
            String this$agentStartTime = this.getAgentStartTime();
            String other$agentStartTime = other.getAgentStartTime();
            if (this$agentStartTime == null ? other$agentStartTime != null : !this$agentStartTime.equals(other$agentStartTime)) {
                return false;
            }
            String this$cpuCore = this.getCpuCore();
            String other$cpuCore = other.getCpuCore();
            if (this$cpuCore == null ? other$cpuCore != null : !this$cpuCore.equals(other$cpuCore)) {
                return false;
            }
            String this$procCpu = this.getProcCpu();
            String other$procCpu = other.getProcCpu();
            if (this$procCpu == null ? other$procCpu != null : !this$procCpu.equals(other$procCpu)) {
                return false;
            }
            String this$freeMem = this.getFreeMem();
            String other$freeMem = other.getFreeMem();
            if (this$freeMem == null ? other$freeMem != null : !this$freeMem.equals(other$freeMem)) {
                return false;
            }
            String this$maxMem = this.getMaxMem();
            String other$maxMem = other.getMaxMem();
            if (this$maxMem == null ? other$maxMem != null : !this$maxMem.equals(other$maxMem)) {
                return false;
            }
            String this$useMem = this.getUseMem();
            String other$useMem = other.getUseMem();
            if (this$useMem == null ? other$useMem != null : !this$useMem.equals(other$useMem)) {
                return false;
            }
            String this$os = this.getOs();
            String other$os = other.getOs();
            if (this$os == null ? other$os != null : !this$os.equals(other$os)) {
                return false;
            }
            String this$installPlatform = this.getInstallPlatform();
            String other$installPlatform = other.getInstallPlatform();
            if (this$installPlatform == null ? other$installPlatform != null : !this$installPlatform.equals(other$installPlatform)) {
                return false;
            }
            String this$usrDir = this.getUsrDir();
            String other$usrDir = other.getUsrDir();
            if (this$usrDir == null ? other$usrDir != null : !this$usrDir.equals(other$usrDir)) {
                return false;
            }
            String this$usrName = this.getUsrName();
            String other$usrName = other.getUsrName();
            if (this$usrName == null ? other$usrName != null : !this$usrName.equals(other$usrName)) {
                return false;
            }
            String this$processId = this.getProcessId();
            String other$processId = other.getProcessId();
            if (this$processId == null ? other$processId != null : !this$processId.equals(other$processId)) {
                return false;
            }
            String this$globalConfigMd5 = this.getGlobalConfigMd5();
            String other$globalConfigMd5 = other.getGlobalConfigMd5();
            if (this$globalConfigMd5 == null ? other$globalConfigMd5 != null : !this$globalConfigMd5.equals(other$globalConfigMd5)) {
                return false;
            }
            String this$taskMd5 = this.getTaskMd5();
            String other$taskMd5 = other.getTaskMd5();
            if (this$taskMd5 == null ? other$taskMd5 != null : !this$taskMd5.equals(other$taskMd5)) {
                return false;
            }
            String this$taskNum = this.getTaskNum();
            String other$taskNum = other.getTaskNum();
            if (this$taskNum == null ? other$taskNum != null : !this$taskNum.equals(other$taskNum)) {
                return false;
            }
            String this$instanceNum = this.getInstanceNum();
            String other$instanceNum = other.getInstanceNum();
            if (this$instanceNum == null ? other$instanceNum != null : !this$instanceNum.equals(other$instanceNum)) {
                return false;
            }
            String this$bootTime = this.getBootTime();
            String other$bootTime = other.getBootTime();
            if (this$bootTime == null ? other$bootTime != null : !this$bootTime.equals(other$bootTime)) {
                return false;
            }
            String this$sendPackageCount = this.getSendPackageCount();
            String other$sendPackageCount = other.getSendPackageCount();
            if (this$sendPackageCount == null ? other$sendPackageCount != null : !this$sendPackageCount.equals(other$sendPackageCount)) {
                return false;
            }
            String this$sendDataLen = this.getSendDataLen();
            String other$sendDataLen = other.getSendDataLen();
            if (this$sendDataLen == null ? other$sendDataLen != null : !this$sendDataLen.equals(other$sendDataLen)) {
                return false;
            }
            String this$sourcePermitLeft = this.getSourcePermitLeft();
            String other$sourcePermitLeft = other.getSourcePermitLeft();
            if (this$sourcePermitLeft == null ? other$sourcePermitLeft != null : !this$sourcePermitLeft.equals(other$sourcePermitLeft)) {
                return false;
            }
            String this$queuePermitLeft = this.getQueuePermitLeft();
            String other$queuePermitLeft = other.getQueuePermitLeft();
            if (this$queuePermitLeft == null ? other$queuePermitLeft != null : !this$queuePermitLeft.equals(other$queuePermitLeft)) {
                return false;
            }
            String this$writerPermitLeft = this.getWriterPermitLeft();
            String other$writerPermitLeft = other.getWriterPermitLeft();
            if (this$writerPermitLeft == null ? other$writerPermitLeft != null : !this$writerPermitLeft.equals(other$writerPermitLeft)) {
                return false;
            }
            String this$activeThreadCount = this.getActiveThreadCount();
            String other$activeThreadCount = other.getActiveThreadCount();
            return !(this$activeThreadCount == null ? other$activeThreadCount != null : !this$activeThreadCount.equals(other$activeThreadCount));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AgentStatus;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $agentIp = this.getAgentIp();
            result = result * 59 + ($agentIp == null ? 43 : $agentIp.hashCode());
            String $tag = this.getTag();
            result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
            String $cluster = this.getCluster();
            result = result * 59 + ($cluster == null ? 43 : $cluster.hashCode());
            String $agentVersion = this.getAgentVersion();
            result = result * 59 + ($agentVersion == null ? 43 : $agentVersion.hashCode());
            String $agentStartTime = this.getAgentStartTime();
            result = result * 59 + ($agentStartTime == null ? 43 : $agentStartTime.hashCode());
            String $cpuCore = this.getCpuCore();
            result = result * 59 + ($cpuCore == null ? 43 : $cpuCore.hashCode());
            String $procCpu = this.getProcCpu();
            result = result * 59 + ($procCpu == null ? 43 : $procCpu.hashCode());
            String $freeMem = this.getFreeMem();
            result = result * 59 + ($freeMem == null ? 43 : $freeMem.hashCode());
            String $maxMem = this.getMaxMem();
            result = result * 59 + ($maxMem == null ? 43 : $maxMem.hashCode());
            String $useMem = this.getUseMem();
            result = result * 59 + ($useMem == null ? 43 : $useMem.hashCode());
            String $os = this.getOs();
            result = result * 59 + ($os == null ? 43 : $os.hashCode());
            String $installPlatform = this.getInstallPlatform();
            result = result * 59 + ($installPlatform == null ? 43 : $installPlatform.hashCode());
            String $usrDir = this.getUsrDir();
            result = result * 59 + ($usrDir == null ? 43 : $usrDir.hashCode());
            String $usrName = this.getUsrName();
            result = result * 59 + ($usrName == null ? 43 : $usrName.hashCode());
            String $processId = this.getProcessId();
            result = result * 59 + ($processId == null ? 43 : $processId.hashCode());
            String $globalConfigMd5 = this.getGlobalConfigMd5();
            result = result * 59 + ($globalConfigMd5 == null ? 43 : $globalConfigMd5.hashCode());
            String $taskMd5 = this.getTaskMd5();
            result = result * 59 + ($taskMd5 == null ? 43 : $taskMd5.hashCode());
            String $taskNum = this.getTaskNum();
            result = result * 59 + ($taskNum == null ? 43 : $taskNum.hashCode());
            String $instanceNum = this.getInstanceNum();
            result = result * 59 + ($instanceNum == null ? 43 : $instanceNum.hashCode());
            String $bootTime = this.getBootTime();
            result = result * 59 + ($bootTime == null ? 43 : $bootTime.hashCode());
            String $sendPackageCount = this.getSendPackageCount();
            result = result * 59 + ($sendPackageCount == null ? 43 : $sendPackageCount.hashCode());
            String $sendDataLen = this.getSendDataLen();
            result = result * 59 + ($sendDataLen == null ? 43 : $sendDataLen.hashCode());
            String $sourcePermitLeft = this.getSourcePermitLeft();
            result = result * 59 + ($sourcePermitLeft == null ? 43 : $sourcePermitLeft.hashCode());
            String $queuePermitLeft = this.getQueuePermitLeft();
            result = result * 59 + ($queuePermitLeft == null ? 43 : $queuePermitLeft.hashCode());
            String $writerPermitLeft = this.getWriterPermitLeft();
            result = result * 59 + ($writerPermitLeft == null ? 43 : $writerPermitLeft.hashCode());
            String $activeThreadCount = this.getActiveThreadCount();
            result = result * 59 + ($activeThreadCount == null ? 43 : $activeThreadCount.hashCode());
            return result;
        }

        public String toString() {
            return "AgentStatusManager.AgentStatus(agentIp=" + this.getAgentIp() + ", tag=" + this.getTag() + ", cluster=" + this.getCluster() + ", agentVersion=" + this.getAgentVersion() + ", agentStartTime=" + this.getAgentStartTime() + ", cpuCore=" + this.getCpuCore() + ", procCpu=" + this.getProcCpu() + ", freeMem=" + this.getFreeMem() + ", maxMem=" + this.getMaxMem() + ", useMem=" + this.getUseMem() + ", os=" + this.getOs() + ", installPlatform=" + this.getInstallPlatform() + ", usrDir=" + this.getUsrDir() + ", usrName=" + this.getUsrName() + ", processId=" + this.getProcessId() + ", globalConfigMd5=" + this.getGlobalConfigMd5() + ", taskMd5=" + this.getTaskMd5() + ", taskNum=" + this.getTaskNum() + ", instanceNum=" + this.getInstanceNum() + ", bootTime=" + this.getBootTime() + ", sendPackageCount=" + this.getSendPackageCount() + ", sendDataLen=" + this.getSendDataLen() + ", sourcePermitLeft=" + this.getSourcePermitLeft() + ", queuePermitLeft=" + this.getQueuePermitLeft() + ", writerPermitLeft=" + this.getWriterPermitLeft() + ", activeThreadCount=" + this.getActiveThreadCount() + ")";
        }

        public AgentStatus(String agentIp, String tag, String cluster, String agentVersion, String agentStartTime, String cpuCore, String procCpu, String freeMem, String maxMem, String useMem, String os, String installPlatform, String usrDir, String usrName, String processId, String globalConfigMd5, String taskMd5, String taskNum, String instanceNum, String bootTime, String sendPackageCount, String sendDataLen, String sourcePermitLeft, String queuePermitLeft, String writerPermitLeft, String activeThreadCount) {
            this.agentIp = agentIp;
            this.tag = tag;
            this.cluster = cluster;
            this.agentVersion = agentVersion;
            this.agentStartTime = agentStartTime;
            this.cpuCore = cpuCore;
            this.procCpu = procCpu;
            this.freeMem = freeMem;
            this.maxMem = maxMem;
            this.useMem = useMem;
            this.os = os;
            this.installPlatform = installPlatform;
            this.usrDir = usrDir;
            this.usrName = usrName;
            this.processId = processId;
            this.globalConfigMd5 = globalConfigMd5;
            this.taskMd5 = taskMd5;
            this.taskNum = taskNum;
            this.instanceNum = instanceNum;
            this.bootTime = bootTime;
            this.sendPackageCount = sendPackageCount;
            this.sendDataLen = sendDataLen;
            this.sourcePermitLeft = sourcePermitLeft;
            this.queuePermitLeft = queuePermitLeft;
            this.writerPermitLeft = writerPermitLeft;
            this.activeThreadCount = activeThreadCount;
        }

        public AgentStatus() {
        }
    }
}

