/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class RemoveClientListenerOperation
extends HotRodOperation<Void>
implements ChannelOperation {
    private final ClientListenerNotifier listenerNotifier;
    private final Object listener;
    private byte[] listenerId;

    protected RemoveClientListenerOperation(Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, ClientListenerNotifier listenerNotifier, Object listener) {
        super((short)39, (short)40, codec, flags, cfg, cacheName, topologyId, channelFactory);
        this.listenerNotifier = listenerNotifier;
        this.listener = listener;
    }

    protected void fetchChannelAndInvoke() {
        this.listenerId = this.listenerNotifier.findListenerId(this.listener);
        if (this.listenerId != null) {
            SocketAddress address = this.listenerNotifier.findAddress(this.listenerId);
            this.channelFactory.fetchChannelAndInvoke(address, this);
        } else {
            this.complete(null);
        }
    }

    @Override
    public void invoke(Channel channel) {
        this.scheduleRead(channel);
        this.sendArrayOperation(channel, this.listenerId);
        this.releaseChannel(channel);
    }

    @Override
    public void cancel(SocketAddress address, Throwable cause) {
        this.completeExceptionally(cause);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (HotRodConstants.isSuccess(status) || HotRodConstants.isNotExecuted(status)) {
            this.listenerNotifier.removeClientListener(this.listenerId);
        }
        this.complete(null);
    }

    @Override
    public CompletableFuture<Void> execute() {
        try {
            this.fetchChannelAndInvoke();
        }
        catch (Exception e) {
            this.completeExceptionally(e);
        }
        return this;
    }
}

