/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.functions.NullByteKeySelector;
import org.apache.flink.cep.EventComparator;
import org.apache.flink.cep.functions.PatternProcessFunction;
import org.apache.flink.cep.functions.TimedOutPartialMatchHandler;
import org.apache.flink.cep.nfa.compiler.NFACompiler;
import org.apache.flink.cep.operator.CepOperator;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

@Internal
final class PatternStreamBuilder<IN> {
    private final DataStream<IN> inputStream;
    private final Pattern<IN, ?> pattern;
    private final EventComparator<IN> comparator;
    private final OutputTag<IN> lateDataOutputTag;
    private final TimeBehaviour timeBehaviour;

    private PatternStreamBuilder(DataStream<IN> inputStream, Pattern<IN, ?> pattern, TimeBehaviour timeBehaviour, @Nullable EventComparator<IN> comparator, @Nullable OutputTag<IN> lateDataOutputTag) {
        this.inputStream = (DataStream)Preconditions.checkNotNull(inputStream);
        this.pattern = (Pattern)Preconditions.checkNotNull(pattern);
        this.timeBehaviour = (TimeBehaviour)((Object)Preconditions.checkNotNull((Object)((Object)timeBehaviour)));
        this.comparator = comparator;
        this.lateDataOutputTag = lateDataOutputTag;
    }

    TypeInformation<IN> getInputType() {
        return this.inputStream.getType();
    }

    <F> F clean(F f) {
        return (F)this.inputStream.getExecutionEnvironment().clean(f);
    }

    PatternStreamBuilder<IN> withComparator(EventComparator<IN> comparator) {
        return new PatternStreamBuilder<IN>(this.inputStream, this.pattern, this.timeBehaviour, (EventComparator)Preconditions.checkNotNull(comparator), this.lateDataOutputTag);
    }

    PatternStreamBuilder<IN> withLateDataOutputTag(OutputTag<IN> lateDataOutputTag) {
        return new PatternStreamBuilder<IN>(this.inputStream, this.pattern, this.timeBehaviour, this.comparator, (OutputTag)Preconditions.checkNotNull(lateDataOutputTag));
    }

    PatternStreamBuilder<IN> inProcessingTime() {
        return new PatternStreamBuilder<IN>(this.inputStream, this.pattern, TimeBehaviour.ProcessingTime, this.comparator, this.lateDataOutputTag);
    }

    PatternStreamBuilder<IN> inEventTime() {
        return new PatternStreamBuilder<IN>(this.inputStream, this.pattern, TimeBehaviour.EventTime, this.comparator, this.lateDataOutputTag);
    }

    <OUT, K> SingleOutputStreamOperator<OUT> build(TypeInformation<OUT> outTypeInfo, PatternProcessFunction<IN, OUT> processFunction) {
        SingleOutputStreamOperator patternStream;
        Preconditions.checkNotNull(outTypeInfo);
        Preconditions.checkNotNull(processFunction);
        TypeSerializer inputSerializer = this.inputStream.getType().createSerializer(this.inputStream.getExecutionConfig());
        boolean isProcessingTime = this.timeBehaviour == TimeBehaviour.ProcessingTime;
        boolean timeoutHandling = processFunction instanceof TimedOutPartialMatchHandler;
        NFACompiler.NFAFactory<IN> nfaFactory = NFACompiler.compileFactory(this.pattern, timeoutHandling);
        CepOperator operator = new CepOperator(inputSerializer, isProcessingTime, nfaFactory, this.comparator, this.pattern.getAfterMatchSkipStrategy(), processFunction, this.lateDataOutputTag);
        if (this.inputStream instanceof KeyedStream) {
            KeyedStream keyedStream = (KeyedStream)this.inputStream;
            patternStream = keyedStream.transform("CepOperator", outTypeInfo, operator);
        } else {
            NullByteKeySelector keySelector = new NullByteKeySelector();
            patternStream = this.inputStream.keyBy((KeySelector)keySelector).transform("GlobalCepOperator", outTypeInfo, operator).forceNonParallel();
        }
        return patternStream;
    }

    static <IN> PatternStreamBuilder<IN> forStreamAndPattern(DataStream<IN> inputStream, Pattern<IN, ?> pattern) {
        return new PatternStreamBuilder<IN>(inputStream, pattern, TimeBehaviour.EventTime, null, null);
    }

    static enum TimeBehaviour {
        ProcessingTime,
        EventTime;

    }
}

