/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.pojo.sort;

import java.io.Serializable;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.common.pojo.sort.TaskConfig;

public class SortConfig
implements Serializable {
    private String sortClusterName;
    private List<TaskConfig> tasks;

    public static SortConfig checkLatest(SortConfig last, SortConfig current) {
        if (last == null) {
            return current;
        }
        if (current == null) {
            return null;
        }
        return SortConfig.builder().sortClusterName(current.getSortClusterName()).tasks(TaskConfig.batchCheckLatest(last.getTasks(), current.getTasks())).build();
    }

    public static SortConfig checkDelete(SortConfig last, SortConfig current) {
        if (last == null) {
            return null;
        }
        if (current == null) {
            return last;
        }
        return SortConfig.check(last, current, TaskConfig::batchCheckDelete);
    }

    public static SortConfig checkUpdate(SortConfig last, SortConfig current) {
        if (last == null || current == null) {
            return null;
        }
        return SortConfig.check(last, current, TaskConfig::batchCheckUpdate);
    }

    public static SortConfig checkNew(SortConfig last, SortConfig current) {
        if (last == null) {
            return current;
        }
        if (current == null) {
            return null;
        }
        return SortConfig.check(last, current, TaskConfig::batchCheckNew);
    }

    public static SortConfig check(SortConfig last, SortConfig current, BiFunction<List<TaskConfig>, List<TaskConfig>, List<TaskConfig>> taskCheckFunction) {
        if (!last.getSortClusterName().equals(current.getSortClusterName())) {
            return null;
        }
        List<TaskConfig> checkTasks = taskCheckFunction.apply(last.getTasks(), current.getTasks());
        if (CollectionUtils.isEmpty(checkTasks)) {
            return null;
        }
        return SortConfig.builder().sortClusterName(last.getSortClusterName()).tasks(checkTasks).build();
    }

    public static SortConfigBuilder builder() {
        return new SortConfigBuilder();
    }

    public String getSortClusterName() {
        return this.sortClusterName;
    }

    public List<TaskConfig> getTasks() {
        return this.tasks;
    }

    public void setSortClusterName(String sortClusterName) {
        this.sortClusterName = sortClusterName;
    }

    public void setTasks(List<TaskConfig> tasks) {
        this.tasks = tasks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortConfig)) {
            return false;
        }
        SortConfig other = (SortConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sortClusterName = this.getSortClusterName();
        String other$sortClusterName = other.getSortClusterName();
        if (this$sortClusterName == null ? other$sortClusterName != null : !this$sortClusterName.equals(other$sortClusterName)) {
            return false;
        }
        List<TaskConfig> this$tasks = this.getTasks();
        List<TaskConfig> other$tasks = other.getTasks();
        return !(this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SortConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sortClusterName = this.getSortClusterName();
        result = result * 59 + ($sortClusterName == null ? 43 : $sortClusterName.hashCode());
        List<TaskConfig> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        return result;
    }

    public String toString() {
        return "SortConfig(sortClusterName=" + this.getSortClusterName() + ", tasks=" + this.getTasks() + ")";
    }

    public SortConfig(String sortClusterName, List<TaskConfig> tasks) {
        this.sortClusterName = sortClusterName;
        this.tasks = tasks;
    }

    public SortConfig() {
    }

    public static class SortConfigBuilder {
        private String sortClusterName;
        private List<TaskConfig> tasks;

        SortConfigBuilder() {
        }

        public SortConfigBuilder sortClusterName(String sortClusterName) {
            this.sortClusterName = sortClusterName;
            return this;
        }

        public SortConfigBuilder tasks(List<TaskConfig> tasks) {
            this.tasks = tasks;
            return this;
        }

        public SortConfig build() {
            return new SortConfig(this.sortClusterName, this.tasks);
        }

        public String toString() {
            return "SortConfig.SortConfigBuilder(sortClusterName=" + this.sortClusterName + ", tasks=" + this.tasks + ")";
        }
    }
}

