/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsg;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;

public class InLongMsgOptions {
    public static final ConfigOption<String> INNER_FORMAT = ConfigOptions.key((String)"inner.format").stringType().noDefaultValue().withDescription("Defines the format identifier for encoding attr data. \nThe identifier is used to discover a suitable format factory.");
    public static final ConfigOption<Boolean> IGNORE_PARSE_ERRORS = ConfigOptions.key((String)"ignore-parse-errors").booleanType().defaultValue((Object)false).withDescription("Optional flag to skip fields and rows with parse errors instead of failing;\nfields are set to null in case of errors");
    public static final ConfigOption<String> TIME_FIELD_NAME = ConfigOptions.key((String)"format.time-field-name").stringType().noDefaultValue().withDescription("The name of the time field in InLongMsg.");
    public static final ConfigOption<String> ATTRIBUTE_FIELD_NAME = ConfigOptions.key((String)"format.attribute-field-name").stringType().noDefaultValue().withDescription("The name of the attribute field in InLongMsg)");
    public static final ConfigOption<String> CHARSET = ConfigOptions.key((String)"format.charset").stringType().defaultValue((Object)"UTF-8").withDescription("Optional text encoding format ('utf-8' by default)");
    public static final ConfigOption<String> FIELD_DELIMITER = ConfigOptions.key((String)"format.field-delimiter").stringType().defaultValue((Object)String.valueOf(',')).withDescription("Optional field delimiter character (',' by default)");
    public static final ConfigOption<String> LINE_DELIMITER = ConfigOptions.key((String)"format.line-delimiter").stringType().noDefaultValue().withDescription("Optional line delimiter character");
    public static final ConfigOption<String> ESCAPE_CHARACTER = ConfigOptions.key((String)"format.escape-character").stringType().noDefaultValue().withDescription("Optional escape character for escaping values (disabled by default)");
    public static final ConfigOption<String> QUOTE_CHARACTER = ConfigOptions.key((String)"format.quote-character").stringType().noDefaultValue().withDescription("Optional quote character for enclosing field values (disabled by default)");
    public static final ConfigOption<String> NULL_LITERAL = ConfigOptions.key((String)"format.null-literal").stringType().noDefaultValue().withDescription("Optional null literal string that is interpreted as a\nnull value (disabled by default)");
    public static final ConfigOption<Boolean> IGNORE_ERRORS = ConfigOptions.key((String)"format.ignore-errors").booleanType().defaultValue((Object)false).withDescription("Optional flag to skip fields and rows with parse errors instead of failing;\nfields are set to null in case of errors");
    public static final ConfigOption<Boolean> DELETE_HEAD_DELIMITER = ConfigOptions.key((String)"format.delete-head-delimiter").booleanType().defaultValue((Object)false).withDescription("True if the head delimiter should be removed (false by default).");
    public static final ConfigOption<Boolean> RETAIN_PREDEFINED_FIELD = ConfigOptions.key((String)"format.retain-predefined-field").booleanType().defaultValue((Object)true).withDescription("True if the retain predefined field should be skip the predefined Field. (true by default).");
    public static final ConfigOption<String> METADATA_FIELD_NAME = ConfigOptions.key((String)"format.metadata-field-name").stringType().defaultValue((Object)"inlongmsg_metadata").withDescription("True if the retain predefined field should be skip the predefined Field. (true by default).");
    public static final ConfigOption<Boolean> INCLUDE_UPDATE_BEFORE = ConfigOptions.key((String)"format.include-update-before").booleanType().defaultValue((Object)false).withDescription("True if the retain predefined field should be skip the predefined Field. (true by default).");
    public static final ConfigOption<Boolean> CSV_IGNORE_PARSE_ERRORS = ConfigOptions.key((String)"csv.ignore-parse-errors").booleanType().defaultValue((Object)false).withDescription("Allows the case that real size exceeds the expected size.\n The extra column will be skipped");
    public static final ConfigOption<Boolean> CSV_IGNORE_TRAILING_UNMAPPABLE = ConfigOptions.key((String)"csv.ignore-trailing-unmappable").booleanType().defaultValue((Object)false).withDescription("Allows the case that real size exceeds the expected size.\n The extra column will be skipped");
    public static final ConfigOption<Boolean> CSV_INSERT_NULLS_FOR_MISSING_COLUMNS = ConfigOptions.key((String)"csv.insert-nulls-for-missing-columns").booleanType().defaultValue((Object)false).withDescription("For missing columns, insert null.");
    public static final ConfigOption<Boolean> CSV_EMPTY_STRING_AS_NULL = ConfigOptions.key((String)"csv.empty-string-as-null").booleanType().defaultValue((Object)false).withDescription("if the string value is empty, make it as null");

    private InLongMsgOptions() {
    }

    public static void validateDecodingFormatOptions(ReadableConfig config) {
        String innerFormat = (String)config.get(INNER_FORMAT);
        if (innerFormat == null) {
            throw new ValidationException(INNER_FORMAT.key() + " shouldn't be null.");
        }
    }
}

