/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jgroups.util.Bits;
import org.jgroups.util.SizeStreamable;

public class Range
implements SizeStreamable,
Comparable<Range> {
    public long low = -1L;
    public long high = -1L;

    public Range() {
    }

    public Range(long low, long high) {
        this.low = low;
        this.high = high;
    }

    public String toString() {
        return "[" + this.low + " : " + this.high + ']';
    }

    @Override
    public int compareTo(Range other) {
        if (this.low == other.low && this.high == other.high) {
            return 0;
        }
        return this.low < other.low ? -1 : 1;
    }

    public int hashCode() {
        return (int)this.low;
    }

    public boolean equals(Object obj) {
        Range other = (Range)obj;
        return this.compareTo(other) == 0;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        Bits.writeLongSequence(this.low, this.high, out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        long[] seqnos = new long[]{0L, 0L};
        Bits.readLongSequence(in, seqnos, 0);
        this.low = seqnos[0];
        this.high = seqnos[1];
    }

    @Override
    public int serializedSize() {
        return Bits.size(this.low, this.high);
    }
}

