/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.metric.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.inlong.audit.metric.AbstractMetric;
import org.apache.inlong.audit.service.config.Configuration;
import org.apache.inlong.audit.service.metric.MetricDimension;
import org.apache.inlong.audit.service.metric.MetricItem;
import org.apache.inlong.audit.service.metric.MetricStat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicePrometheusMetric
extends Collector
implements AbstractMetric {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServicePrometheusMetric.class);
    private static final String HELP_DESCRIPTION = "Audit service metrics help description";
    public static final String AUDIT_SERVICE_SERVER_NAME = "audit-service";
    private static final String METRIC_API_TYPE = "apiType";
    private static final String METRIC_DIMENSION = "dimension";
    private final MetricItem metricItem;
    private HTTPServer server;

    public ServicePrometheusMetric(MetricItem metricItem) {
        this.metricItem = metricItem;
        try {
            this.server = new HTTPServer(Configuration.getInstance().get("audit.service.prometheus.port", 10084));
            this.register();
        }
        catch (IOException e) {
            LOGGER.error("Construct store prometheus metric has IOException", (Throwable)e);
        }
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        for (Map.Entry entry : this.metricItem.getMetricStatMap().entrySet()) {
            String apiType = (String)entry.getKey();
            MetricStat stat = (MetricStat)entry.getValue();
            samples.add(this.createSample(MetricDimension.COUNT, apiType, stat.getCount().get()));
            samples.add(this.createSample(MetricDimension.DURATION, apiType, stat.getDuration().get()));
        }
        Collector.MetricFamilySamples metricFamilySamples = new Collector.MetricFamilySamples(AUDIT_SERVICE_SERVER_NAME, Collector.Type.GAUGE, HELP_DESCRIPTION, samples);
        return Collections.singletonList(metricFamilySamples);
    }

    private Collector.MetricFamilySamples.Sample createSample(MetricDimension metricDimension, String apiType, long statValue) {
        return new Collector.MetricFamilySamples.Sample(AUDIT_SERVICE_SERVER_NAME, Arrays.asList(METRIC_API_TYPE, METRIC_DIMENSION), Arrays.asList(apiType, metricDimension.getKey()), (double)statValue);
    }

    public void report() {
        if (this.metricItem != null) {
            LOGGER.info("Report Service Prometheus metric: {}", (Object)this.metricItem);
        } else {
            LOGGER.warn("MetricItem is null, nothing to report.");
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.close();
            LOGGER.info("Prometheus HTTP server stopped successfully.");
        } else {
            LOGGER.warn("Prometheus HTTP server is not running.");
        }
    }
}

