/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.node;

import java.util.UUID;
import org.apache.inlong.audit.service.cache.AuditRouteCache;
import org.apache.inlong.audit.service.config.Configuration;
import org.apache.inlong.audit.service.entities.JdbcConfig;
import org.apache.inlong.audit.service.metric.MetricsManager;
import org.apache.inlong.audit.service.node.ApiService;
import org.apache.inlong.audit.service.node.ConfigService;
import org.apache.inlong.audit.service.node.EtlService;
import org.apache.inlong.audit.service.node.PartitionManager;
import org.apache.inlong.audit.service.selector.api.Selector;
import org.apache.inlong.audit.service.selector.api.SelectorConfig;
import org.apache.inlong.audit.service.selector.api.SelectorFactory;
import org.apache.inlong.audit.service.utils.JdbcUtils;
import org.apache.inlong.common.util.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(Application.class);
    private static final EtlService etlService = new EtlService();
    private static final ApiService apiService = new ApiService();
    private static Selector selector;
    private static boolean running;

    public static void main(String[] args) {
        try {
            ConfigService.getInstance().start();
            PartitionManager.getInstance().start();
            MetricsManager.getInstance().init();
            AuditRouteCache.getInstance().init();
            etlService.start();
            apiService.start();
            Application.stopIfKilled();
            Application.waitToBeLeader();
        }
        catch (Exception ex) {
            LOGGER.error("Running exception: ", (Throwable)ex);
        }
    }

    private static void stopIfKilled() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                running = false;
                etlService.stop();
                apiService.stop();
                selector.close();
                MetricsManager.getInstance().shutdown();
                AuditRouteCache.getInstance().shutdown();
                LOGGER.info("Stopping gracefully");
            }
            catch (Exception ex) {
                LOGGER.error("Stop error: ", (Throwable)ex);
            }
        }));
    }

    private static void initSelector() {
        JdbcConfig jdbcConfig = JdbcUtils.buildMysqlConfig();
        String leaderId = NetworkUtils.getLocalIp() + "-" + UUID.randomUUID();
        LOGGER.info("Init selector. Leader id is :{}", (Object)leaderId);
        if (selector == null) {
            SelectorConfig electorConfig = new SelectorConfig(Configuration.getInstance().get("selector.service.id", "audit-service"), leaderId, jdbcConfig.getJdbcUrl(), jdbcConfig.getUserName(), jdbcConfig.getPassword(), jdbcConfig.getDriverClass());
            selector = SelectorFactory.getNewElector((SelectorConfig)electorConfig);
            try {
                selector.init();
            }
            catch (Exception e) {
                LOGGER.error("Init selector has exception:", (Throwable)e);
            }
        }
    }

    private static void waitToBeLeader() {
        Application.initSelector();
        while (running) {
            try {
                Thread.sleep(Configuration.getInstance().get("selector.follower.listen.cycle.ms", 2000));
            }
            catch (Exception e) {
                LOGGER.error("Wait to be Leader has exception! lost Leadership!", (Throwable)e);
            }
            if (!selector.isLeader()) continue;
            LOGGER.info("I get Leadership! Begin to aggregate clickhouse data to mysql");
            etlService.auditSourceToMysql();
            return;
        }
    }

    static {
        running = true;
    }
}

