/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.flink;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.StringJoiner;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.audit.AuditIdEnum;
import org.apache.inlong.audit.entity.FlowType;
import org.apache.inlong.manager.pojo.audit.AuditInfo;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FlinkParallelismOptimizer {
    private static final Logger log = LoggerFactory.getLogger(FlinkParallelismOptimizer.class);
    @Value(value="${audit.query.url:http://127.0.0.1:10080}")
    public String auditQueryUrl;
    private static final int MAX_PARALLELISM = 2048;
    private long maximumMessagePerSecondPerCore = 1000L;
    private static final long DEFAULT_ERROR_DATA_VOLUME = 0L;
    private static final FlowType DEFAULT_FLOWTYPE = FlowType.OUTPUT;
    private static final String DEFAULT_AUDIT_TYPE = "DataProxy";
    private static final String AUDIT_CYCLE_REALTIME = "1";
    private static final int DATA_SCALE_COUNTING_RANGE_IN_HOURS = 1;
    private static final String AUDIT_QUERY_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String LOGTS_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String TIMEZONE_REGEX = "([+-])(\\d):";

    public int calculateRecommendedParallelism(List<InlongStreamInfo> streamInfos) {
        long averageDataVolume;
        InlongStreamInfo streamInfo = streamInfos.get(0);
        try {
            averageDataVolume = this.getAverageDataVolume(streamInfo);
            log.info("Retrieved data volume: {}", (Object)averageDataVolume);
        }
        catch (Exception e) {
            log.error("Error retrieving data volume: {}", (Object)e.getMessage(), (Object)e);
            averageDataVolume = 0L;
        }
        int newParallelism = (int)(averageDataVolume / this.maximumMessagePerSecondPerCore);
        newParallelism = Math.min(newParallelism, 2048);
        log.info("Calculated parallelism: {} for data volume: {}", (Object)newParallelism, (Object)averageDataVolume);
        return newParallelism;
    }

    public void setMaximumMessagePerSecondPerCore(Integer maximumMessagePerSecondPerCore) {
        if (maximumMessagePerSecondPerCore == null || maximumMessagePerSecondPerCore <= 0) {
            log.error("Illegal flink.max.msg.rate.percore property, must be nonnull and positive, using default value: {}", (Object)this.maximumMessagePerSecondPerCore);
        } else {
            this.maximumMessagePerSecondPerCore = maximumMessagePerSecondPerCore.intValue();
        }
    }

    private long getAverageDataVolume(InlongStreamInfo streamInfo) {
        String dataTimeZone = ((StreamSource)streamInfo.getSourceList().get(0)).getDataTimeZone();
        dataTimeZone = dataTimeZone.replaceAll(TIMEZONE_REGEX, "$10$2:");
        ZoneId dataZone = ZoneId.of(dataTimeZone);
        ZonedDateTime endTime = ZonedDateTime.now(dataZone);
        ZonedDateTime startTime = endTime.minusHours(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(AUDIT_QUERY_DATE_TIME_FORMAT);
        int auditId = AuditIdEnum.getAuditId((String)DEFAULT_AUDIT_TYPE, (FlowType)DEFAULT_FLOWTYPE).getValue();
        StringJoiner urlParameters = new StringJoiner("&").add("startTime=" + startTime.format(formatter)).add("endTime=" + endTime.format(formatter)).add("inlongGroupId=" + streamInfo.getInlongGroupId()).add("inlongStreamId=" + streamInfo.getInlongStreamId()).add("auditId=" + auditId).add("auditCycle=1");
        String url = this.auditQueryUrl + "/audit/query/minutes" + "?" + urlParameters;
        return this.getAverageDataVolumeFromAuditInfo(url);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private long getAverageDataVolumeFromAuditInfo(String url) {
        log.debug("Requesting audit data from URL: {}", (Object)url);
        try {
            Throwable throwable = null;
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                long l;
                Throwable throwable2;
                CloseableHttpResponse response;
                block34: {
                    block35: {
                        HttpGet httpGet = new HttpGet(url);
                        response = httpClient.execute((HttpUriRequest)httpGet);
                        throwable2 = null;
                        l = this.parseResponseAndCalculateAverageDataVolume(response);
                        if (response == null) break block34;
                        if (throwable2 == null) break block35;
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block34;
                    }
                    response.close();
                }
                return l;
                catch (Throwable throwable4) {
                    try {
                        try {
                            try {
                                throwable2 = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (response != null) {
                                    if (throwable2 != null) {
                                        try {
                                            response.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable2.addSuppressed(throwable6);
                                        }
                                    } else {
                                        response.close();
                                    }
                                }
                                throw throwable5;
                            }
                        }
                        catch (IOException e) {
                            log.error("Error executing HTTP request to audit API: {}", (Object)url, (Object)e);
                            if (httpClient != null) {
                                if (throwable != null) {
                                    try {
                                        httpClient.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable.addSuppressed(throwable7);
                                    }
                                } else {
                                    httpClient.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    catch (Throwable throwable9) {
                        throw throwable9;
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("Error creating or closing HTTP client: {}", (Object)url, (Object)e);
        }
        return 0L;
    }

    private long parseResponseAndCalculateAverageDataVolume(CloseableHttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            log.warn("Empty response entity from audit API, returning default count.");
            return 0L;
        }
        String responseString = EntityUtils.toString((HttpEntity)entity);
        log.debug("Flink dynamic parallelism optimizer got response from audit API: {}", (Object)responseString);
        JsonObject jsonObject = JsonParser.parseString((String)responseString).getAsJsonObject();
        AuditInfo[] auditInfoArray = (AuditInfo[])new Gson().fromJson((JsonElement)jsonObject.getAsJsonArray("data"), AuditInfo[].class);
        ChronoZonedDateTime minLogTs = null;
        ChronoZonedDateTime maxLogTs = null;
        DateTimeFormatter logTsFormatter = DateTimeFormatter.ofPattern(LOGTS_DATE_TIME_FORMAT).withZone(ZoneId.systemDefault());
        long totalCount = 0L;
        for (AuditInfo auditData : auditInfoArray) {
            if (auditData != null) {
                ZonedDateTime logTs = ZonedDateTime.parse(auditData.getLogTs(), logTsFormatter);
                if (minLogTs == null || logTs.isBefore(minLogTs)) {
                    minLogTs = logTs;
                }
                if (maxLogTs == null || logTs.isAfter(maxLogTs)) {
                    maxLogTs = logTs;
                }
                log.debug("parsed AuditInfo, Count: {}, Size: {}", (Object)auditData.getCount(), (Object)auditData.getSize());
                totalCount += auditData.getCount();
                continue;
            }
            log.error("Null AuditInfo found in response data.");
        }
        if (minLogTs != null && maxLogTs != null) {
            long timeDifferenceInSeconds = maxLogTs.toEpochSecond() - minLogTs.toEpochSecond();
            log.info("Time difference in seconds: {}", (Object)timeDifferenceInSeconds);
            if (timeDifferenceInSeconds > 0L) {
                return totalCount / timeDifferenceInSeconds;
            }
        }
        return 0L;
    }
}

