/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.aaaclient;

import java.security.SecureRandom;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.inlong.tubemq.corebase.aaaclient.ClientAuthenticateHandler;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientMaster;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;

public class SimpleClientAuthenticateHandler
implements ClientAuthenticateHandler {
    @Override
    public ClientMaster.AuthenticateInfo.Builder genMasterAuthenticateToken(String userName, String usrPassWord) {
        long timestamp = System.currentTimeMillis();
        int nonce = new SecureRandom(StringUtils.getBytesUtf8((String)String.valueOf(timestamp))).nextInt(Integer.MAX_VALUE);
        String signature = TStringUtils.getAuthSignature(userName, usrPassWord, timestamp, nonce);
        ClientMaster.AuthenticateInfo.Builder authBuilder = ClientMaster.AuthenticateInfo.newBuilder();
        authBuilder.setUserName(userName);
        authBuilder.setTimestamp(timestamp);
        authBuilder.setNonce(nonce);
        authBuilder.setOthParams("");
        authBuilder.setSignature(signature);
        return authBuilder;
    }

    @Override
    public String genBrokerAuthenticateToken(String userName, String usrPassWord) {
        long timestamp = System.currentTimeMillis();
        int nonce = new SecureRandom(StringUtils.getBytesUtf8((String)String.valueOf(timestamp))).nextInt(Integer.MAX_VALUE);
        String signature = TStringUtils.getAuthSignature(userName, usrPassWord, timestamp, nonce);
        return new StringBuilder(512).append(userName).append(" ").append(timestamp).append(" ").append(nonce).append(" ").append(signature).toString();
    }
}

