/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.utils;

import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientMaster;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;

public class OpsSyncInfo {
    private boolean updated = false;
    private long groupFlowChkId = -2L;
    private long defFlowChkId = -2L;
    private int qryPriorityId = -2;
    private long csmFrmMaxOffsetCtrlId = -2L;
    private boolean requireAuth = false;
    private String defFlowControlInfo = "";
    private String groupFlowControlInfo = "";

    public void updOpsSyncInfo(ClientMaster.OpsTaskInfo opsTaskInfo) {
        if (opsTaskInfo == null) {
            return;
        }
        if (opsTaskInfo.hasDefFlowCheckId()) {
            this.defFlowChkId = opsTaskInfo.getDefFlowCheckId();
            this.updated = true;
        }
        if (opsTaskInfo.hasGroupFlowCheckId()) {
            this.groupFlowChkId = opsTaskInfo.getGroupFlowCheckId();
            this.updated = true;
        }
        if (opsTaskInfo.hasQryPriorityId()) {
            this.qryPriorityId = opsTaskInfo.getQryPriorityId();
            this.updated = true;
        }
        if (opsTaskInfo.hasCsmFrmMaxOffsetCtrlId() && opsTaskInfo.getCsmFrmMaxOffsetCtrlId() >= 0L) {
            this.csmFrmMaxOffsetCtrlId = opsTaskInfo.getCsmFrmMaxOffsetCtrlId();
            this.updated = true;
        }
        if (opsTaskInfo.hasRequireAuth() && opsTaskInfo.getRequireAuth()) {
            this.requireAuth = true;
            this.updated = true;
        }
        if (opsTaskInfo.hasDefFlowControlInfo() && TStringUtils.isNotBlank(opsTaskInfo.getDefFlowControlInfo())) {
            this.defFlowControlInfo = opsTaskInfo.getDefFlowControlInfo();
            this.updated = true;
        }
        if (opsTaskInfo.hasGroupFlowControlInfo() && TStringUtils.isNotBlank(opsTaskInfo.getGroupFlowControlInfo())) {
            this.groupFlowControlInfo = opsTaskInfo.getGroupFlowControlInfo();
            this.updated = true;
        }
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public long getGroupFlowChkId() {
        return this.groupFlowChkId;
    }

    public long getDefFlowChkId() {
        return this.defFlowChkId;
    }

    public int getQryPriorityId() {
        return this.qryPriorityId;
    }

    public long getCsmFromMaxOffsetCtrlId() {
        return this.csmFrmMaxOffsetCtrlId;
    }

    public boolean isRequireAuth() {
        return this.requireAuth;
    }

    public String getDefFlowControlInfo() {
        return this.defFlowControlInfo;
    }

    public String getGroupFlowControlInfo() {
        return this.groupFlowControlInfo;
    }

    public void clear() {
        this.updated = false;
        this.groupFlowChkId = -2L;
        this.defFlowChkId = -2L;
        this.qryPriorityId = -2;
        this.csmFrmMaxOffsetCtrlId = -2L;
        this.requireAuth = false;
        this.defFlowControlInfo = "";
        this.groupFlowControlInfo = "";
    }
}

