/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor.memory;

import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import io.debezium.connector.oracle.logminer.processor.AbstractTransaction;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryTransaction
extends AbstractTransaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryTransaction.class);
    private int numberOfEvents;
    private List<LogMinerEvent> events = new ArrayList<LogMinerEvent>();

    public MemoryTransaction(String transactionId, Scn startScn, Instant changeTime, String userName) {
        super(transactionId, startScn, changeTime, userName);
        this.start();
    }

    @Override
    public int getNumberOfEvents() {
        return this.numberOfEvents;
    }

    @Override
    public int getNextEventId() {
        return this.numberOfEvents++;
    }

    @Override
    public void start() {
        this.numberOfEvents = 0;
    }

    public List<LogMinerEvent> getEvents() {
        return this.events;
    }

    public void removeEventWithRowId(String rowId) {
        this.events.removeIf(event -> {
            if (event.getRowId().equals(rowId)) {
                LOGGER.trace("Undo applied for event {}.", event);
                return true;
            }
            return false;
        });
    }

    @Override
    public String toString() {
        return "MemoryTransaction{numberOfEvents=" + this.numberOfEvents + "} " + super.toString();
    }
}

