/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common;

public class CircuitBreaker {
    private Setting setting;
    private State state = State.Closed;
    private long generation;
    private long expiry;
    private int failures;
    private int all;
    private int consecutiveSuccesses;
    private int consecutiveFailures;

    public CircuitBreaker() {
        this(new Setting());
    }

    public CircuitBreaker(Setting setting) {
        this.setting = setting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token allow() {
        CircuitBreaker circuitBreaker = this;
        synchronized (circuitBreaker) {
            long now = System.currentTimeMillis();
            StateResult result = this.currentState(now);
            if (result.state == State.Open) {
                return new Token(false, this.generation, this);
            }
            return new Token(true, this.generation, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void report(long beforeGeneration, boolean success) {
        CircuitBreaker circuitBreaker = this;
        synchronized (circuitBreaker) {
            long now = System.currentTimeMillis();
            StateResult result = this.currentState(now);
            if (result.generation != beforeGeneration) {
                return;
            }
            if (success) {
                this.onSuccess(result.state, now);
            } else {
                this.onFailure(result.state, now);
            }
        }
    }

    private StateResult currentState(long now) {
        switch (this.state) {
            case Closed: {
                if (this.expiry >= now) break;
                this.toNewGeneration(now);
                break;
            }
            case Open: {
                if (this.expiry >= now) break;
                this.setState(State.HalfOpen, now);
            }
        }
        return new StateResult(this.state, this.generation);
    }

    private void toNewGeneration(long now) {
        ++this.generation;
        this.all = 0;
        this.failures = 0;
        this.consecutiveSuccesses = 0;
        switch (this.state) {
            case Closed: {
                this.expiry = now + this.setting.windowIntervalMs;
                break;
            }
            case Open: {
                this.expiry = now + this.setting.timeoutMs;
                break;
            }
            case HalfOpen: {
                this.expiry = 0L;
            }
        }
    }

    private void setState(State newState, long now) {
        if (this.state == newState) {
            return;
        }
        this.state = newState;
        this.toNewGeneration(now);
    }

    private void onSuccess(State state, long now) {
        switch (state) {
            case Closed: {
                ++this.all;
                ++this.consecutiveSuccesses;
                this.consecutiveFailures = 0;
                break;
            }
            case HalfOpen: {
                ++this.all;
                ++this.consecutiveSuccesses;
                this.consecutiveFailures = 0;
                if (this.all - this.failures <= this.setting.maxRequests) break;
                this.setState(State.Closed, now);
            }
        }
    }

    private void onFailure(State state, long now) {
        switch (state) {
            case Closed: {
                ++this.all;
                ++this.failures;
                this.consecutiveSuccesses = 0;
                this.consecutiveFailures = 0;
                if (!this.readyToOpen()) break;
                this.setState(State.Open, now);
                break;
            }
            case HalfOpen: {
                this.setState(State.Open, now);
            }
        }
    }

    private boolean readyToOpen() {
        float failPre = (float)this.failures / (float)this.all;
        return this.failures >= this.setting.maxFailNum && failPre >= this.setting.maxFailPercentage || this.consecutiveFailures > 5;
    }

    public static class Token {
        public boolean allowed;
        private long generation;
        private CircuitBreaker circuitBreaker;

        private Token(boolean allowed, long generation, CircuitBreaker circuitBreaker) {
            this.allowed = allowed;
            this.generation = generation;
            this.circuitBreaker = circuitBreaker;
        }

        public void report(boolean success) {
            this.circuitBreaker.report(this.generation, success);
        }
    }

    private static class StateResult {
        public State state;
        public long generation;

        public StateResult(State state, long generation) {
            this.state = state;
            this.generation = generation;
        }
    }

    private static enum State {
        Closed,
        HalfOpen,
        Open;

    }

    public static class Setting {
        public int maxFailNum = 5;
        public float maxFailPercentage = 0.75f;
        public long windowIntervalMs = 300000L;
        public long timeoutMs = 6000L;
        public int maxRequests;
    }
}

