/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sinks;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.message.BatchProxyMessage;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.plugin.sinks.AbstractSink;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.common.pojo.dataproxy.MQClusterInfo;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSink
extends AbstractSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaSink.class);
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new AgentThreadFactory("KafkaSink"));
    private final AgentConfiguration agentConf = AgentConfiguration.getAgentConf();
    private volatile boolean shutdown = false;
    private List<MQClusterInfo> mqClusterInfos;
    private String topic;
    private List<KafkaSender> kafkaSenders;
    private static final AtomicInteger KAFKA_SENDER_INDEX = new AtomicInteger(0);
    private LinkedBlockingQueue<BatchProxyMessage> kafkaSendQueue;
    private int producerNum;
    private boolean asyncSend;

    @Override
    public void init(InstanceProfile jobConf) {
        super.init(jobConf);
        int sendQueueSize = this.agentConf.getInt("agent.sink.kafka.send.queue.size", 20000);
        this.kafkaSendQueue = new LinkedBlockingQueue(sendQueueSize);
        this.producerNum = this.agentConf.getInt("agent.sink.kafka.producer.num", 3);
        this.asyncSend = this.agentConf.getBoolean("agent.sink.kafka.enbale.async.send", true);
        this.mqClusterInfos = jobConf.getMqClusters();
        Preconditions.checkArgument((ObjectUtils.isNotEmpty((Object)jobConf.getMqTopic()) && jobConf.getMqTopic().isValid() ? 1 : 0) != 0, (Object)"no valid kafka topic config");
        this.topic = jobConf.getMqTopic().getTopic();
        this.kafkaSenders = new ArrayList<KafkaSender>();
        this.initKafkaSender();
        EXECUTOR_SERVICE.execute(this.sendDataThread());
    }

    public boolean write(Message message) {
        return true;
    }

    public void destroy() {
        LOGGER.info("destroy job[{}] kafka sink", (Object)this.jobInstanceId);
        while (!this.sinkFinish()) {
            LOGGER.info("job[{}] wait until cache all data to kafka", (Object)this.jobInstanceId);
            AgentUtils.silenceSleepInMs((long)this.batchFlushInterval);
        }
        this.shutdown = true;
        if (CollectionUtils.isNotEmpty(this.kafkaSenders)) {
            for (KafkaSender sender : this.kafkaSenders) {
                sender.close();
            }
            this.kafkaSenders.clear();
        }
    }

    public boolean sinkFinish() {
        return true;
    }

    private Runnable sendDataThread() {
        return () -> {
            LOGGER.info("start kafka sink send data thread, job[{}], groupId[{}]", (Object)this.jobInstanceId, (Object)this.inlongGroupId);
            while (!this.shutdown) {
                try {
                    BatchProxyMessage data = this.kafkaSendQueue.poll(1L, TimeUnit.MILLISECONDS);
                    if (ObjectUtils.isEmpty((Object)data)) continue;
                    this.sendData(data);
                }
                catch (Throwable t) {
                    LOGGER.error("send job[{}] data to kafka error", (Object)this.jobInstanceId, (Object)t);
                }
            }
        };
    }

    private void sendData(BatchProxyMessage batchMsg) throws InterruptedException {
        if (ObjectUtils.isEmpty((Object)batchMsg)) {
            return;
        }
        KafkaProducer<String, byte[]> producer = this.selectProducer();
        if (ObjectUtils.isEmpty(producer)) {
            this.kafkaSendQueue.put(batchMsg);
            LOGGER.error("send job[{}] data err, empty kafka producer", (Object)this.jobInstanceId);
            return;
        }
        ProducerRecord record = new ProducerRecord(this.topic, (Object)batchMsg.getInLongMsg().buildArray());
        this.sinkMetric.pluginSendCount.addAndGet(batchMsg.getMsgCnt());
        if (this.asyncSend) {
            producer.send(record, (Callback)new AsyncSinkCallback(System.currentTimeMillis(), batchMsg));
        } else {
            try {
                Future future = producer.send(record);
                future.get(3000L, TimeUnit.MILLISECONDS);
                this.updateSuccessSendMetrics(batchMsg);
            }
            catch (Exception e) {
                this.sinkMetric.pluginSendFailCount.addAndGet(batchMsg.getMsgCnt());
                LOGGER.error("send job[{}] data fail to kafka, add back to send queue, send queue size {}", new Object[]{this.jobInstanceId, this.kafkaSendQueue.size(), e});
                this.kafkaSendQueue.put(batchMsg);
            }
        }
    }

    private void updateSuccessSendMetrics(BatchProxyMessage batchMsg) {
        AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_SEND_SUCCESS, (String)batchMsg.getGroupId(), (String)batchMsg.getStreamId(), (long)batchMsg.getDataTime(), (int)batchMsg.getMsgCnt(), (long)batchMsg.getTotalSize());
        this.sinkMetric.pluginSendSuccessCount.addAndGet(batchMsg.getMsgCnt());
    }

    private KafkaProducer<String, byte[]> selectProducer() {
        if (CollectionUtils.isEmpty(this.kafkaSenders)) {
            LOGGER.error("send job[{}] data err, empty kafka sender", (Object)this.jobInstanceId);
            return null;
        }
        KafkaSender sender = this.kafkaSenders.get((KAFKA_SENDER_INDEX.getAndIncrement() & Integer.MAX_VALUE) % this.kafkaSenders.size());
        return sender.getProducer();
    }

    private void initKafkaSender() {
        if (CollectionUtils.isEmpty(this.mqClusterInfos)) {
            LOGGER.error("init job[{}] kafka producer fail, empty mqCluster info", (Object)this.jobInstanceId);
            return;
        }
        for (MQClusterInfo clusterInfo : this.mqClusterInfos) {
            if (!clusterInfo.isValid()) continue;
            this.kafkaSenders.add(new KafkaSender(clusterInfo, this.producerNum));
        }
    }

    class AsyncSinkCallback
    implements Callback {
        private long startTime;
        private BatchProxyMessage batchMsg;

        public AsyncSinkCallback(long startTime, BatchProxyMessage batchMsg) {
            this.startTime = startTime;
            this.batchMsg = batchMsg;
        }

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            if (exception != null) {
                KafkaSink.this.sinkMetric.pluginSendFailCount.addAndGet(this.batchMsg.getMsgCnt());
                LOGGER.error("send job[{}] data fail to kafka, will add back to sendqueue, current sendqueue size {}", new Object[]{KafkaSink.this.jobInstanceId, KafkaSink.this.kafkaSendQueue.size(), exception});
                try {
                    KafkaSink.this.kafkaSendQueue.put(this.batchMsg);
                }
                catch (InterruptedException ex) {
                    LOGGER.error("put job[{}] data back to queue fail, send queue size {}", new Object[]{KafkaSink.this.jobInstanceId, KafkaSink.this.kafkaSendQueue.size(), ex});
                }
            } else {
                KafkaSink.this.updateSuccessSendMetrics(this.batchMsg);
            }
            if (LOGGER.isDebugEnabled()) {
                long elapsedTime = System.currentTimeMillis() - this.startTime;
                if (metadata != null) {
                    LOGGER.debug("acked job[{}] message partition:{} ofset:{}", new Object[]{KafkaSink.this.jobInstanceId, metadata.partition(), metadata.offset()});
                }
                LOGGER.debug("job[{}] send data to kafka elapsed time: {}", (Object)KafkaSink.this.jobInstanceId, (Object)elapsedTime);
            }
        }
    }

    class KafkaSender {
        private final Properties kafkaProps = new Properties();
        private List<KafkaProducer<String, byte[]>> producers;
        private final AtomicInteger producerIndex = new AtomicInteger(0);

        public KafkaSender(MQClusterInfo clusterInfo, int producerNum) {
            this.setKafkaProps(clusterInfo);
            this.initKafkaProducer(this.kafkaProps, producerNum);
        }

        private void setKafkaProps(MQClusterInfo clusterInfo) {
            String saslJaasConfig;
            String saslMechanism;
            String securityProtocol;
            String batchSize;
            this.kafkaProps.clear();
            Map params = clusterInfo.getParams();
            String bootStrapServers = (String)params.get("bootstrap.servers");
            if (bootStrapServers == null) {
                throw new IllegalArgumentException("kafka param bootstrap.servers is null");
            }
            this.kafkaProps.put("bootstrap.servers", bootStrapServers);
            String acks = (String)params.get("acks");
            if (StringUtils.isNotEmpty((CharSequence)acks)) {
                this.kafkaProps.put("acks", acks);
            } else {
                this.kafkaProps.put("acks", "1");
            }
            String compressionType = (String)params.get("compression.type");
            if (StringUtils.isNotEmpty((CharSequence)compressionType)) {
                this.kafkaProps.put("compression.type", compressionType);
            } else {
                this.kafkaProps.put("compression.type", "none");
            }
            String keySerializer = (String)params.get("key.serializer");
            if (StringUtils.isNotEmpty((CharSequence)keySerializer)) {
                this.kafkaProps.put("key.serializer", keySerializer);
            } else {
                this.kafkaProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
            }
            String valueSerializer = (String)params.get("value.serializer");
            if (StringUtils.isNotEmpty((CharSequence)keySerializer)) {
                this.kafkaProps.put("value.serializer", valueSerializer);
            } else {
                this.kafkaProps.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
            }
            String lingerMs = (String)params.get("linger.ms");
            if (StringUtils.isNotEmpty((CharSequence)lingerMs)) {
                this.kafkaProps.put("linger.ms", (Object)Integer.parseInt(lingerMs));
            }
            if (StringUtils.isNotEmpty((CharSequence)(batchSize = (String)params.get("batch.size")))) {
                this.kafkaProps.put("batch.size", (Object)Integer.parseInt(batchSize));
            }
            String bufferMemory = (String)params.get("buffer.memory");
            if (StringUtils.isNotEmpty((CharSequence)batchSize)) {
                this.kafkaProps.put("buffer.memory", (Object)Integer.parseInt(bufferMemory));
            }
            if (StringUtils.isNotEmpty((CharSequence)(securityProtocol = (String)params.get("security.protocol")))) {
                this.kafkaProps.put("security.protocol", securityProtocol);
            }
            if (StringUtils.isNotEmpty((CharSequence)(saslMechanism = (String)params.get("sasl.mechanism")))) {
                this.kafkaProps.put("sasl.mechanism", saslMechanism);
            }
            if (StringUtils.isNotEmpty((CharSequence)(saslJaasConfig = (String)params.get("sasl.jaas.config")))) {
                this.kafkaProps.put("sasl.jaas.config", saslJaasConfig);
            }
        }

        private void initKafkaProducer(Properties kafkaProps, int producerNum) {
            this.producers = new ArrayList<KafkaProducer<String, byte[]>>(producerNum);
            for (int i = 0; i < producerNum; ++i) {
                this.producers.add((KafkaProducer<String, byte[]>)new KafkaProducer(kafkaProps));
            }
        }

        public KafkaProducer<String, byte[]> getProducer() {
            if (CollectionUtils.isEmpty(this.producers)) {
                LOGGER.error("job[{}] empty producers", (Object)KafkaSink.this.jobInstanceId);
                return null;
            }
            int index = (this.producerIndex.getAndIncrement() & Integer.MAX_VALUE) % this.producers.size();
            return this.producers.get(index);
        }

        public void close() {
            if (CollectionUtils.isEmpty(this.producers)) {
                return;
            }
            for (KafkaProducer<String, byte[]> producer : this.producers) {
                producer.close();
            }
        }
    }
}

